// tutorial21.cxx

#include <stdio.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/helpers/SbFileHelper.h>

#include <Inventor/nodes/SoSeparator.h>
#include <MeshViz/nodes/PoParalCartesianGrid2D.h>
#include <MeshViz/nodes/PoLinearDataMapping.h>
#include <MeshViz/3Ddata/PoMeshFilled.h>



/*----------------------------------------------------------------------------*/
void 
read_mesh(const char *filename, int &nx, float **x, int &ny, float **y) 
{
  FILE *file_rep;

  file_rep = fopen ( filename , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",filename);
    exit(1);
  }
  int i,num_x,num_y;
  fscanf (file_rep , "%d%d" , &num_x, &num_y);
  nx = num_x;
  ny = num_y;
  float *xt = (float *)malloc(num_x*sizeof(float));
  float *yt = (float *)malloc(num_y*sizeof(float));
  for (i=0; i<num_x; i++) fscanf(file_rep,"%f",&xt[i]);
  for (i=0; i<num_y; i++) fscanf(file_rep,"%f",&yt[i]);
  *x = xt;
  *y = yt;
}/*---------------------------------------------------------------------------*/

void 
read_val(const char *filename, int num_val, float **val, float &vmin, float &vmax, float &undef)
{
  FILE *file_rep;
  float vv;
  int i;

  file_rep = fopen ( filename , "r" );
  if (file_rep == NULL ) {
    printf ("file %s not found\n",filename);
    exit(2);
  }

  vmin=1E30F;
  vmax=-1E30F;
  float *v = (float *)malloc(num_val*sizeof(float));
  for (i=0; i<num_val; i++) {
    fscanf(file_rep,"%f",&vv);
    v[i] = vv;
    if (vmin > vv) vmin = vv;
    if (vmax < vv) vmax = vv;
  }

  undef = vmax;
  vmax = vmin;
  // find the greatest "valid" value (i.e. the greatest
  // one but lower than undef_value)
  for (i=0; i<num_val; i++) if (vmax < v[i] && v[i] < undef) vmax = v[i];
    
  *val = v;
}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  // Read back from file mesh data and geometry
  int num_x,num_y;
  float *xm,*ym, *vm, vmin,vmax,undef;
 
  SbString MeshFile=SbFileHelper::expandString("$OIVHOME/examples/source/MeshViz/Mentor/UNDEFGRID.TOPO");
  SbString MeshValFile=SbFileHelper::expandString("$OIVHOME/examples/source/MeshViz/Mentor/IDESUNI.DAT");
  
  read_mesh(MeshFile.toLatin1 (), num_x, &xm, num_y, &ym) ;
  read_val(MeshValFile.toLatin1 (), num_x*num_y, &vm,vmin,vmax,undef);
  
  // Define data mapping
  PoLinearDataMapping *myDataMapping = new PoLinearDataMapping;
  myDataMapping->color1 = SbColor(1,0,0); myDataMapping->value1 = vmin;
  myDataMapping->color2 = SbColor(0,1,1); myDataMapping->value2 = vmax;
  myDataMapping->maxThreshold = undef;
  myDataMapping->maxThresholdEnabled = TRUE;
  //  myDataMapping->maxThresholdColor = SbColor(0.2,0.2,0.2);
  myDataMapping->maxThresholdTransparency = 1.0;
  myDataMapping->transparencyEnabled = TRUE;

  // Initialize the mesh
  PoParalCartesianGrid2D *mesh = new PoParalCartesianGrid2D;
  mesh->setGeometry(num_x, num_y, xm,ym);
  mesh->addValuesSet(0,vm);

  // Create the solid contour visualization node.
  PoMeshFilled *myFill = new PoMeshFilled;
  myFill->valuesIndex.setValue(0);
  myFill->coloringType = PoMesh::COLOR_MAPPING;

  SoSeparator *root = new SoSeparator ;
  root->ref();
  root->addChild(mesh);
  root->addChild(myDataMapping);
  root->addChild(myFill);

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


