// tutorial22.cxx

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <MeshViz/graph/PoLinearValueLegend.h>
#include <MeshViz/nodes/PoLinearDataMapping.h>
#include <MeshViz/nodes/PoIsovaluesList.h>

#include <Inventor/SoWinApp.h>

int 
main(int, char **argv)
{
  
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize MeshViz
  PoMeshViz::init() ;
  
  // Define the data-color mapping
  PoLinearDataMapping *myDataMapping = new PoLinearDataMapping;
  myDataMapping->color1 = SbColor(0,0,1); myDataMapping->value1 = 0;
  myDataMapping->color2 = SbColor(1,0,0); myDataMapping->value1 = 10;

  // Define list of values
  PoIsovaluesList *myList = new PoIsovaluesList;
  myList->setRegularIsoList(0.,9.,10);

  // Create the legend node
  PoLinearValueLegend *legend = new PoLinearValueLegend(SbVec2f(0.,0.),
							SbVec2f(0.3F, 1.0F)) ;
  legend->set("backgroundApp.material", "diffuseColor .4 .4 .4") ;

  // Create the root of our scene graph
  SoAnnotation *root = new SoAnnotation;
  root->ref();
  root->addChild(myDataMapping);
  root->addChild(myList);
  root->addChild(legend);

  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  viewer->setSceneGraph(root);
  viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


