// tutorial23.cxx

#include <stdio.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <MeshViz/graph/PoBase.h>
#include <MeshViz/nodes/PoCartesianGrid2D.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>
#include <MeshViz/nodes/PoIsovaluesList.h>
#include <MeshViz/graph/PoNonLinearValueLegend1.h>
#include <MeshViz/3Ddata/PoMeshFilled.h>


#include <Inventor/helpers/SbFileHelper.h>

void 
read_mesh(int *nx, float* &x, int *ny, float* &y) 
{
  FILE *f;
  int i,j,n;
  float c;
  
  f = SbFileHelper::open ("$OIVHOME/examples/source/MeshViz/Mentor/mesh2D.geo", "r" );
  if (f == NULL ) exit(-1);
  
  fscanf (f , "%d%d" , nx, ny);
  x = (float *)malloc(*nx * *ny * sizeof(float));
  y = (float *)malloc(*nx * *ny *sizeof(float));

  for (i = 0, n = 0; i < *nx; i++) { 
    fscanf(f,"%f",&c);
    for (j = 0; j < *ny; j++,n++) x[n] = c;
  }
  for (j=  0; j < *ny; j++) {
    n = j;
    fscanf(f,"%f",&c);
    for (i = 0; i < *nx; i++, n += *ny) y[n] = c;
  }
}

void 
read_val(int nv, float **val, float *vmin, float *vmax)
{
  FILE *f;
  float c;
  
  f = SbFileHelper::open ("$OIVHOME/examples/source/MeshViz/Mentor/mesh2D.dat", "r" );
  if (f == NULL ) exit(-1);
  
  *vmin=1E30F;
  *vmax=-1E30F;
  float *v = (float *)malloc(nv * sizeof(float));
  for (int i = 0; i < nv; i++) {
    fscanf(f,"%f",&c);
    v[i] = c;
    if (*vmin > c) *vmin = c;
    if (*vmax < c) *vmax = c;
  }
  
  *val = v;
}

#include <Inventor/SoWinApp.h>

int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  // Read back from file mesh data and geometry
  int numX,numY;
  float *xm,*ym,*vm,vmin,vmax;
  read_mesh(&numX, xm, &numY, ym) ;
  read_val(numX*numY, &vm, &vmin, &vmax);
  
  // Define data mapping
  SbColor colors[5] = {SbColor(0,0,1), SbColor(0,1,1), 
		       SbColor(0,1,0),	SbColor(1,1,0), 
		       SbColor(1,0,0)} ;
  float val[5];
  val[0] = vmin; 
  for (int i=1; i<5; i++) val[i] = val[i-1]+(vmax-vmin)/4.f;
  PoNonLinearDataMapping2 *myDataMapping = new PoNonLinearDataMapping2;
  myDataMapping->type = PoNonLinearDataMapping2::LINEAR_PER_LEVEL;
  myDataMapping->value.setValues(0,5,val);
  myDataMapping->color.setValues(0,5,colors);

  // Define the list of iso-values
  PoIsovaluesList *myIsovaluesList = new PoIsovaluesList;
  myIsovaluesList->setRegularIsoList(vmin,vmax,16);

  // Initialize the mesh
  PoCartesianGrid2D *mesh = new PoCartesianGrid2D;
  mesh->setGeometry (numX, numY, xm,ym);
  mesh->addValuesSet(0,vm);

  // Create legend node
  PoNonLinearValueLegend1 *myLegend = 
    new PoNonLinearValueLegend1(SbVec2f(-1,1),SbVec2f(-.5,-.5));
  myLegend->set("backgroundApp.material", "diffuseColor .4 .4 .4") ;

  SoAnnotation *legendAnnot =  new SoAnnotation ;
  legendAnnot->addChild(myLegend) ;
   
  // Create the solid contour visualization node.
  PoMeshFilled *myFill = new PoMeshFilled;
  myFill->valuesIndex.setValue(0);
  myFill->zValuesIndex.setValue(0);
  myFill->coloringType = PoMesh::COLOR_CONTOURING ;

  SoPerspectiveCamera *myCamera = new SoPerspectiveCamera;

  // Create the root of our scene graph
  SoSeparator *root = new SoSeparator ;
  root->ref();
  root->addChild(mesh);
  root->addChild(myIsovaluesList);
  root->addChild(myDataMapping);
  root->addChild(legendAnnot);
  root->addChild(myCamera);
  root->addChild(myFill);

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setBackgroundColor(SbColor(1., 1., 1.)) ;
#ifdef _WIN32
  viewer->setCursorStyle(SoWinViewer::XOR);
#endif
  myCamera->viewAll(root,viewer->getViewportRegion());
  viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}


