/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Author(s) (Jan 1996)
** Modified by : J. SEILER (MMM yyyy)
**=======================================================================*/
#include <Inventor/SbColor.h>
#include <Inventor/nodes/SoMaterial.h>
#include <assert.h>

#include "PoDialogColorControl.h"

#include <DialogViz/SoDialogVizAll.h>

const size_t MAX_COLORS = 9;

class ColorSliderAuditor : public SoDialogRealSliderAuditor
{
  PoDialogColorControl* m_dialogColorControl;
public:
  ColorSliderAuditor(PoDialogColorControl *dialogColorControl) : m_dialogColorControl(dialogColorControl)
  {}

  void dialogRealSlider(SoDialogRealSlider* /*cpt*/)
  {
    m_dialogColorControl->updateSlidersColors();
  }
};

class MaterialAuditor : public SoDialogChoiceAuditor
{
  PoDialogColorControl* m_dialogColorControl;
public:
  MaterialAuditor(PoDialogColorControl *dialogColorControl) : m_dialogColorControl(dialogColorControl)
  {}

  void
  dialogChoice( SoDialogChoice* cpt )
  {
    m_dialogColorControl->_currentColor = &m_dialogColorControl->_colorList[cpt->selectedItem.getValue()];

    float hue, sat, val;
    m_dialogColorControl->_colorList[cpt->selectedItem.getValue()].getHSVValue( hue, sat, val );

    m_dialogColorControl->m_hueSlider->value = hue;
    m_dialogColorControl->m_saturationSlider->value = sat;
    m_dialogColorControl->m_valueSlider->value = val;

    m_dialogColorControl->updateSlidersColors();
  }
};

PoDialogColorControl::PoDialogColorControl( Widget parent,
                                            const char* name,
                                            int itemsChoiceNumber,
                                            const char** itemsChoiceList,
                                            int currentItem,
                                            SbColor* colorList,
                                            const SbBool insideParent )
  : _valueChangedCB( new SoCallbackList )
  , _colorChangedCB( new SoCallbackList )
{
  _colorList = new SbColor[itemsChoiceNumber];
  for ( int i = 0; i < itemsChoiceNumber; i++ )
    _colorList[i].setValue( colorList[i].getValue() );
  _currentColor = &_colorList[currentItem];

  assert( itemsChoiceNumber > currentItem || itemsChoiceNumber <= 0 || itemsChoiceNumber == 0 || colorList == 0 );
  buildDialogBox( name, itemsChoiceNumber, itemsChoiceList, currentItem );

  buildDialog( parent, insideParent );
}/*-------------------------------------------------------------------*/

PoDialogColorControl::~PoDialogColorControl()
{
  delete _colorChangedCB;
  delete _valueChangedCB;
  delete[] _colorList;
}/*-------------------------------------------------------------------*/

void
PoDialogColorControl::buildDialogBox( const char* name,
                                      int itemsChoiceNumber,
                                      const char** itemsChoiceList,
                                      int currentItem )
{
  label = name;

  m_materialCombo = new SoDialogComboBox();
  m_materialCombo->label.setValue( "Material :" );
  m_materialCombo->items.setValues( 0, itemsChoiceNumber, itemsChoiceList );
  m_materialCombo->selectedItem = currentItem;
  m_materialCombo->addAuditor( new MaterialAuditor( this ) );
  addChild( m_materialCombo );

  // create slider with good values
  float hue, sat, val;
  _colorList[currentItem].getHSVValue( hue, sat, val );

  m_hueSlider = new SoDialogRealSlider();
  m_hueSlider->label = "Hue :";
  m_hueSlider->min = 0.0f;
  m_hueSlider->max = 1.0f;
  m_hueSlider->value = hue;
  m_hueSlider->addAuditor( new ColorSliderAuditor( this ) );
  addChild( m_hueSlider );

  m_saturationSlider = new SoDialogRealSlider();
  m_saturationSlider->label = "Saturation :";
  m_saturationSlider->min = 0.0f;
  m_saturationSlider->max = 1.0f;
  m_saturationSlider->value = sat;
  m_saturationSlider->addAuditor( new ColorSliderAuditor( this ) );
  addChild( m_saturationSlider );

  m_valueSlider = new SoDialogRealSlider();
  m_valueSlider->label = "Value :";
  m_valueSlider->min = 0.0f;
  m_valueSlider->max = 1.0f;
  m_valueSlider->value = val;
  m_valueSlider->addAuditor( new ColorSliderAuditor( this ) );
  addChild( m_valueSlider );

  updateSlidersColors();
}/*-------------------------------------------------------------------*/

void
PoDialogColorControl::updateSlidersColors()
{
  _currentColor->setHSVValue( m_hueSlider->value.getValue(),
                              m_saturationSlider->value.getValue(),
                              m_valueSlider->value.getValue() );

  SbColor hueColors[MAX_COLORS];
  SbColor colors[2];

  float hue, sat, val;
  _currentColor->getHSVValue( hue, sat, val );

  float step = 1.0 / float( MAX_COLORS - 1 );
  for ( size_t i = 0; i < MAX_COLORS; i++ )
  {
    float hueValue = float( i ) * step;
    hueColors[i].setHSVValue( hueValue, sat, val );
  }

  m_hueSlider->colors.setValues( 0, MAX_COLORS, hueColors );

  colors[0].setHSVValue( hue, 0.0, val );
  colors[1].setHSVValue( hue, 1.0, val );
  m_saturationSlider->colors.setValues( 0, 2, colors );

  colors[0].setHSVValue( hue, sat, 0.0 );
  colors[1].setHSVValue( hue, sat, 1.0 );
  m_valueSlider->colors.setValues( 0, 2, colors );

  _colorChangedCB->invokeCallbacks( this );
}/*-------------------------------------------------------------------*/

int 
PoDialogColorControl::getCurrentItem() const
{
  return m_materialCombo->selectedItem.getValue();
}/*-------------------------------------------------------------------*/

SbColor
PoDialogColorControl::getCurrentColor() const
{
  return *_currentColor;
}/*-------------------------------------------------------------------*/

void 
PoDialogColorControl::setSize(int x, int y)
{
  width = x;
  height = y;
}/*-------------------------------------------------------------------*/

void 
PoDialogColorControl::addValueChangedCallback(DialogColorControlCB *func,
					      void *userData)
{
  _valueChangedCB->addCallback((SoCallbackListCB *)func, userData);
}/*-------------------------------------------------------------------*/

void 
PoDialogColorControl::removeValueChangedCallback(DialogColorControlCB *func,
						 void *userData)
{
  _valueChangedCB->removeCallback((SoCallbackListCB *)func, userData);
}
/*-------------------------------------------------------------------*/
void 
PoDialogColorControl::addColorChangedCallback(DialogColorControlCB *func,
					      void *userData)
{
  _colorChangedCB->addCallback((SoCallbackListCB *)func, userData);
}/*-------------------------------------------------------------------*/

void 
PoDialogColorControl::removeColorChangedCallback(DialogColorControlCB *func,
						 void *userData)
{
  _colorChangedCB->removeCallback((SoCallbackListCB *)func, userData);
}/*-------------------------------------------------------------------*/


