/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Author(s) (Jan 1996)
** Modified by : J. SEILER (MMM yyyy)
**=======================================================================*/
#ifndef PO_DIALOG_COLOR_CONTROL_H
#define PO_DIALOG_COLOR_CONTROL_H

#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogComboBox.h>

class SbColor;

class MaterialAuditor;

class PoDialogColorControl : public SoTopLevelDialog
{
  friend class MaterialAuditor;
public:

  typedef void DialogColorControlCB( void* userData, const PoDialogColorControl* dialog );

  PoDialogColorControl( Widget parent,
                        const char* name,
                        int itemsChoiceNumber,
                        const char** itemsChoiceList,
                        int currentItem,
                        SbColor* colorList,
                        const SbBool insideParent = FALSE );

  ~PoDialogColorControl(); 

  // callback wgen the slider color changed
  void addColorChangedCallback( DialogColorControlCB* function, void* userData = NULL );
  void removeColorChangedCallback( DialogColorControlCB* function, void* userData = NULL );

  // callback when an insert xtElement changed (not slider)
  void addValueChangedCallback( DialogColorControlCB* function, void* userData = NULL );
  void removeValueChangedCallback( DialogColorControlCB* function, void* userData = NULL );

  void setSize(int x, int y);

  int getCurrentItem() const;
  SbColor getCurrentColor() const;

  void updateSlidersColors();

private:
  SoCallbackList *_valueChangedCB;
  SoCallbackList *_colorChangedCB;

  SbColor *_colorList;
  SbColor *_currentColor;

  SoDialogComboBox* m_materialCombo;

  SoDialogRealSlider* m_hueSlider;
  SoDialogRealSlider* m_saturationSlider;
  SoDialogRealSlider* m_valueSlider;

  void buildDialogBox( const char* name, int itemsChoiceNumber, const char** itemsChoiceList, int currentItem );
};

#endif //PO_DIALOG_COLOR_CONTROL_H


