//
// PoAngularAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoAngularAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

SoSeparator    *root ;

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

#include <GraphEditors.h>
#include <GraphAuditors.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();
  
  SoSeparator *root = new SoSeparator ;
  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(-1., -1.,0) ;
  myDomain->max.setValue(1., 1.,0) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  
  PoAngularAxis *angularAxis = new PoAngularAxis(0.5, 0.0, 2.5, 1.0, 0.0) ;
  angularAxis->titleVisibility = PoAxis::VISIBILITY_ON ;
  angularAxis->titlePosition = PoAxis::TITLE_END ;
  angularAxis->titleString.setValue("X-Axis") ;
  angularAxis->gradPath = PoAxis::PATH_TANGENT ;
  angularAxis->gridVisibility = PoAxis::VISIBILITY_ON ;
  angularAxis->gridLengthGradSide = 0.0 ;
  angularAxis->gridLengthGradOtherSide = 0.4F ;

  // Create axis editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createAngularAxisEditor();

  AngularGraphAuditor* myAuditor = new AngularGraphAuditor( angularAxis );

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();
  
  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(angularAxis) ;
  
  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Angular Axis");
  
  viewer->show();
  viewer->viewAll();
  editor->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  editor = NULL;
  delete myAuditor;

  delete viewer;
  root->unref();
  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


