//
// PoArrow
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoArrow.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  SbVec2f arrowPts[2] = {SbVec2f(.5F, .4F), SbVec2f(.6F, .8F)} ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  SoAnnotation *root = new SoAnnotation ;
  PoArrow *arrow = new PoArrow(2, arrowPts, PoArrow::DIRECT_TRIANGLE, PoArrow::DIRECT_TRIANGLE) ;
  arrow->set("bodyApp.material", "diffuseColor [1 0 0]") ;
  arrow->set("startApp.material", "diffuseColor [0 1 0]") ;
  arrow->set("endApp.material", "diffuseColor [0 0 1]") ;
  
  root->ref() ;
  root->addChild(arrow) ;

  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Arrow");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


