//
// PoAutoCubeAxis
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoEnvironment.h>

#include <MeshViz/graph/PoAutoCubeAxis.h>

#include <MeshViz/nodes/PoDomain.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(0., 0.,0) ;
  myDomain->max.setValue(1., 10., 100) ;

  SoSeparator *root = new SoSeparator ;
  root->ref() ;
  root->addChild(myDomain) ;

  SoEnvironment *environment = new SoEnvironment ;
  environment->ambientIntensity.setValue(1.5) ;
  root->addChild(environment) ;

  PoAutoCubeAxis *autoCubeAxis = new 
    PoAutoCubeAxis(SbVec3f(0., 0., 0.), SbVec3f(1., 10., 100.), PoAutoCubeAxis::LINEAR,
		   PoAutoCubeAxis::LINEAR, PoAutoCubeAxis::LINEAR, "X", "Y", "Z") ;
  autoCubeAxis->set("backgroundFaceApp.material", "diffuseColor 1 0 0") ;
  autoCubeAxis->isBackgroundFacesVisible = TRUE ;
  root->addChild(autoCubeAxis) ;
  
  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Auto Cube Axis");
  viewer->viewAll() ;
  viewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  root->unref();
  delete viewer;

  PoMeshViz::finish();
  SoXt::finish();
  return 0;
}/*---------------------------------------------------------------------------*/


