//
// Test for PoBiErrorPointField 
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoBiErrorPointField.h>

#define NP 12

static SbVec2f point[NP]={SbVec2f(0.5F,0.5F),SbVec2f(1.5F,3.8F),SbVec2f(1.8F,1.2F),
			  SbVec2f(2.4F,1.9F),SbVec2f(3.2F,8.3F),SbVec2f(4.5F,4.F),
			  SbVec2f(5.9F,3.2F),SbVec2f(6.3F,9.5F),SbVec2f(8.0F,3.0F),
			  SbVec2f(8.5F,6.3F), SbVec2f(9.0F,7.5F),SbVec2f(9.5F,9.1F)};

static float low_x_r[NP] = {0.4F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1.F, 0.4F, 0.2F, 0.8F} ;
static float low_y_r[NP]= {0.4F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1.F, 0.4F, 0.2F, 0.8F} ;
static float high_x_r[NP] = {1.F, 0.6F, 0.5F, 0.2F, 0.4F, 0.6F, 0.8F, 0.5F, 1.F, 0.3F, 0.5F, 0.5F} ;
static float high_y_r[NP] = {1.5F, 0.5F, 0.2F, 0.3F, 0.6F, 0.8F, 0.2F, 0.5F, 1.F, 0.4F, 0.2F, 0.8F} ;

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoAnnotation *root = new SoAnnotation ;
   PoBiErrorPointField *berrPtFld = new PoBiErrorPointField(NP, point, low_x_r, low_y_r, 
							    high_x_r, high_y_r) ;

   berrPtFld->set("shapeApp.material", "diffuseColor [0 0 1]") ;
   berrPtFld->set("skeletonApp.material", "diffuseColor [1 0 0]") ;
   
   root->ref() ;
   root->addChild(berrPtFld) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Bi-Error Point Field");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


