//
// PoCircle3CenterRadius and
// PoCircle3ThreePoints
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoCircle3CenterRadius.h>
#include <MeshViz/graph/PoCircle3ThreePoints.h>


/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoCircle3CenterRadius *circle = new 
     PoCircle3CenterRadius(SbVec3f(5.0, 5.0, 0.0), 1.0, SbVec3f(1., 0., 1.)) ;

   PoCircle3ThreePoints *circle2 = new PoCircle3ThreePoints() ;
   
   root->ref() ;
   root->addChild(circle) ;
   root->addChild(circle2) ;

   SoXtExaminerViewer *viewer = 
     new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Circle 3");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


