//
// PoCircleArcCtrPtAngle and
// PoCircleArcCtrTwoPts  and
// PoCircleArcThreePts   and
// PoCircleArcCtrRadTwoAngle
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoCircleArcCtrPtAngle.h>
#include <MeshViz/graph/PoCircleArcCtrTwoPts.h>
#include <MeshViz/graph/PoCircleArcThreePts.h>
#include <MeshViz/graph/PoCircleArcCtrRadTwoAngle.h>


/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoCircleArcCtrPtAngle *circleArc = new 
     PoCircleArcCtrPtAngle(SbVec2f(0.0, 0.0), SbVec2f(1.0, 0.0), 1.5) ;

   PoCircleArcCtrTwoPts *circleArc2 = new 
     PoCircleArcCtrTwoPts(SbVec2f(2.0F, 2.0F), SbVec2f(2.5F, 1.7F), SbVec2f(2.1F, 2.5F)) ;

   PoCircleArcThreePts *circleArc3 = new 
     PoCircleArcThreePts(SbVec2f(-2.0, -2.0), SbVec2f(-2.5, -2.5), SbVec2f(-3, -2));
   
   PoCircleArcCtrRadTwoAngle *circleArc4 = new
     PoCircleArcCtrRadTwoAngle(SbVec2f(2, -2), 1., 0.8F, 2.5F) ;

   root->ref() ;
   root->addChild(circleArc) ;
   root->addChild(circleArc2) ;
   root->addChild(circleArc3) ;
   root->addChild(circleArc4) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Circle Arc");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


