//
// PoCircleArc3CtrPtAngle and
// PoCircleArc3CtrTwoPts  and
// PoCircleArc3ThreePts
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoCircleArc3CtrPtAngle.h>
#include <MeshViz/graph/PoCircleArc3CtrTwoPts.h>
#include <MeshViz/graph/PoCircleArc3ThreePts.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoCircleArc3CtrPtAngle *circleArc = new 
     PoCircleArc3CtrPtAngle(SbVec3f(0.0, 0.0, 0.0), SbVec3f(1.0, 0.0, 0.0), 1.5, 
			    SbVec3f(0., 0.5, 0.5)) ;

   PoCircleArc3CtrTwoPts *circleArc2 = new 
     PoCircleArc3CtrTwoPts(SbVec3f(2.0F, 2.0F, 0.0F), SbVec3f(2.5F, 1.7F, 0.0F), SbVec3f(2.1F, 2.5F, 0.0F)) ;

   PoCircleArc3ThreePts *circleArc3 = new 
     PoCircleArc3ThreePts(SbVec3f(-2.0, -2.0, 0.0), SbVec3f(-2.5, -2.5, 0.0), SbVec3f(-3, -2, 0.0));
   

   root->ref() ;
   root->addChild(circleArc) ;
   root->addChild(circleArc2) ;
   root->addChild(circleArc3) ;

   SoXtExaminerViewer *viewer = 
     new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Circle Arc 3");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


