//
// PoCoordinateSystemAxis
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoCoordinateSystemAxis.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  SoSeparator *root = new SoSeparator ;
  PoCoordinateSystemAxis *coordSystAxis = new PoCoordinateSystemAxis() ;
  coordSystAxis->titleTranslationFactor.setValue(0.1F) ;
  coordSystAxis->set("xArrow.appearance.material", "diffuseColor 1 0 0") ;
  coordSystAxis->set("yArrow.appearance.material", "diffuseColor 0 1 0") ;
  coordSystAxis->set("zArrow.appearance.material", "diffuseColor 0 0 1") ;
  coordSystAxis->set("appearance.font", "name Courier size 10") ;
  
  root->ref() ;
  root->addChild(coordSystAxis) ;

  SoXtExaminerViewer *viewer = 
    new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Coordinate Sytem Axis");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


