//
// PoCurve
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NP            14
#define PERIOD_X      0.5

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  SbVec2f curvePts[NP]={SbVec2f(0.5F,0.5F),SbVec2f(1.5F,3.8F),SbVec2f(1.8F,1.2F),
			SbVec2f(2.4F,1.9F),SbVec2f(3.2F,6.3F),SbVec2f(4.5F,7.2F),
			SbVec2f(6.3F,9.3F),SbVec2f(6.9F,7.2F),SbVec2f(8.0F,6.0F),
			SbVec2f(8.5F,6.3F),SbVec2f(9.0F,7.5F),SbVec2f(9.5F,4.1F),
			SbVec2f(9.8F,3.5F),SbVec2f(10.F,1.5F)};

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoDomain *myDomain = new PoDomain ;
  
  myDomain->min.setValue(0., 0., 0) ;
  myDomain->max.setValue(10., 10., 0) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoAnnotation *root = new SoAnnotation ;

  PoCurve *curve = new PoCurve(NP, curvePts) ;

  curve->curveRep = PoCurve::CURVE_SMOOTH ;
  curve->raiseFilterType = PoCurve::X_PERIOD ;
  curve->raiseXPeriod = PERIOD_X ;
  curve->raiseThreshold = 0.0 ;
  curve->isCurveFilled = TRUE ;

  curve->markerFilterType = PoCurve::X_PERIOD ;
  curve->markerXPeriod = PERIOD_X ;

  curve->set("markerApp.material", "diffuseColor [0 1 0]") ;
  curve->set("markerApp.drawStyle", "pointSize 5.0") ;
  curve->set("curvePointApp.material", "diffuseColor [1 0 0]") ;
  curve->set("curveFillingApp.material", "diffuseColor [0 0 1]") ;
  
  PoGroup2Axis *g2Axis = new 
    PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup2Axis::LINEAR, 
		 PoGroup2Axis::LINEAR, "X-Axis", "Y-Axis") ;

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(curve) ;
  root->addChild(g2Axis) ;

  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Curve");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


