//
// PoErrorCurve
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/events/SoEvents.h>
#include <Inventor/nodekits/SoBaseKit.h>

#include <MeshViz/graph/PoErrorCurve.h>

#define NP 12

static SbVec2f point[NP]={SbVec2f(0.5,5.), SbVec2f(1.5,6.5), SbVec2f(2.5,7.), SbVec2f(3.,6.5), 
			  SbVec2f(3.5,6.), SbVec2f(4.5,5.5), SbVec2f(5.5,6.5), SbVec2f(6.,7.5), 
			  SbVec2f(6.5,7.), SbVec2f(7.5,6.), SbVec2f(8.5,5.), SbVec2f(9.5,4.5)} ;

static float low_y_r[NP] = { 0.5F, 0.6F, 0.8F, 1.F, 0.3F, 0.7F, 0.8F, 1.2F, 0.4F, 0.6F, 0.8F, 1.2F} ;
static float high_y_r[NP] = { 1.F, 0.5F, 0.6F, 1.2F, 0.5F, 1.F, 0.4F, 0.3F, 1.5F, 0.2F, 0.7F, 0.9F} ;

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoAnnotation *root = new SoAnnotation ;
   PoErrorCurve *errCurve = new PoErrorCurve(NP, point, low_y_r, high_y_r) ;
   errCurve->errorCurveRep = PoErrorCurve::FILLED ;

   errCurve->set("errorCurve1App.material", "diffuseColor [1 0 0]") ;
   errCurve->set("errorCurve2App.material", "diffuseColor [0 1 0]") ;
   errCurve->set("errorCurve3App.material", "diffuseColor [0 0 1]") ;
   errCurve->set("errorCurve4App.material", "diffuseColor [1 1 0]") ;
   errCurve->set("errorCurve5App.material", "diffuseColor [0 1 1]") ;
   
   root->ref() ;
   root->addChild(errCurve) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Error Curve");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


