//
// PoErrorPointField 
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoErrorPointField.h>

#define NP 12

static SbVec2f point[NP]={SbVec2f(0.5F,0.5F),SbVec2f(1.5F,3.8F),SbVec2f(1.8F,1.2F),
			  SbVec2f(2.4F,1.9F),SbVec2f(3.2F,6.3F),SbVec2f(4.5F,7.2F),
			  SbVec2f(6.3F,9.3F),SbVec2f(6.9F,7.2F),SbVec2f(8.0F,6.0F),
			  SbVec2f(8.5F,6.3F),SbVec2f(9.0F,7.5F),SbVec2f(9.2F,8.1F)};

static float errorX[NP] = {0.4F, 0.5F, 0.5F, 0.25F, 1.F, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F} ;
static float errorY[NP] = {0.4F, 1.5F, 0.25F, 0.5F, 0.5F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F, 0.25F, 0.5F} ;


/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoAnnotation *root = new SoAnnotation ;
   PoErrorPointField *errPtFld = new PoErrorPointField(NP, point, errorX, errorY) ; 
   errPtFld->shapeType = PoErrorPointField::ELLIPSE_SHAPE ;
   errPtFld->skeletonType = PoErrorPointField::CROSS3_SKELETON ;

   errPtFld->set("shapeApp.material", "diffuseColor [0 0 1]") ;
   errPtFld->set("skeletonApp.material", "diffuseColor [1 0 0]") ;
   
   root->ref() ;
   root->addChild(errPtFld) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Error Point Field");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


