//
// PoGenAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoGenAxis.h>

#include <MeshViz/nodes/PoMiscTextAttr.h>
/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>
#include <GraphEditors.h>
#include <GraphAuditors.h>


int  main(int, char **argv)
{
  static const char *country[] = {"France", "Germany", "U.S.A", "Italy", "Belgium"} ;
  static const char *town[] = {"Paris", "Berlin", "Chicago", "Naples", "Brussels"} ;
  
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;
   SoDialogViz::init();

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   SoSeparator *root = new SoSeparator ;
   
   PoGenAxis *genAxisX = new PoGenAxis ;
   genAxisX->titleVisibility = PoGenAxis::VISIBILITY_ON ;
   genAxisX->titleString.setValue("X-Axis") ;
   genAxisX->gradList.setValues(0, 5, (const char**)country) ;
   genAxisX->set("bodyApp.material", "diffuseColor 1 0 0") ;

   PoGenAxis *genAxisY = new 
     PoGenAxis(SbVec3f(0.,0.,0.), 1., PoGenAxis::YX, (const char**) town, 5) ;

   // Create axis editor
   SoRef<SoTopLevelDialog> editor = GraphEditors::createCartesianAxisEditor();

   CartesianGraphAuditor* myAuditor = new CartesianGraphAuditor( genAxisX );

   editor->addAuditor(myAuditor);
   editor->setSynchronizable(false);
   editor->buildDialog( myWindow, FALSE );
   editor->show();

 
   root->ref() ;
   root->addChild(myTextAttr) ;
   root->addChild(genAxisX) ;
   root->addChild(genAxisY) ;
   
   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Gen Axis");
   
   viewer->show();
   viewer->viewAll();
   editor->show();
   
   SoXt::show(myWindow);
   SoXt::mainLoop();

  editor = NULL;
  delete myAuditor;

  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


