//
// PoGeneralizedBar
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoScale.h>

#include <MeshViz/graph/PoGeneralizedBar.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoRegularMesh1D.h>
#include <MeshViz/nodes/PoMesh1DHints.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NP            10

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  float y[NP] = {0.5F, 3.8F, 1.2F, 7.2F, 9.3F, 7.2F, 6.0F, 7.5F, 4.1F, 1.5F}  ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoDomain *myDomain = new PoDomain ;  
  myDomain->min.setValue(0., 0., 0) ;
  myDomain->max.setValue(10., 10., 10) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoSeparator *root = new SoSeparator ;

  PoRegularMesh1D *mesh1D = new PoRegularMesh1D ;
  mesh1D->setGeometry(NP, 0.5, 9.5) ;
  mesh1D->addValuesSet(0, y) ;

  // There are 3 possible shapes for the bars
  // which are a cone, a cylinder and
  // a queen (stored in an IV file).
  SoSeparator *coneSep = new SoSeparator ;
  coneSep->addChild(new SoCone) ;
  
  SoSeparator *cylinderSep = new SoSeparator ;
  cylinderSep->addChild(new SoCylinder) ;
  
  SoInput input ;
  SbBool genfile = input.openFile("$OIVHOME/examples/data/MeshViz/queen.iv") ;
  if(!genfile) {
	exit(1);
  }
  SoSeparator *queenSep = SoDB::readAll(&input) ;
  input.closeFile() ;
  SoScale *scale = new SoScale ;
  scale->scaleFactor.setValue(70,70,70) ;
  queenSep->insertChild(scale, 0) ;

  PoGeneralizedBar *generalizedBar = new PoGeneralizedBar ;
  generalizedBar->threshold = 5 ;
  generalizedBar->scaleFactor.setValue(0.35F, 0.35F, 0.35F) ;
  generalizedBar->bars.set1Value(0, coneSep) ;
  generalizedBar->bars.set1Value(1, cylinderSep) ;
  generalizedBar->bars.set1Value(2, queenSep) ;

  PoGroup2Axis *g2Axis = new 
    PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup2Axis::LINEAR, 
		 PoGroup2Axis::LINEAR, "X-Axis", "Y-Axis") ;

  SoMaterial *material = new SoMaterial ;
  material->ambientColor.setValue(1,1,1) ;
  material->diffuseColor.setValue(1,0,0) ;
  material->specularColor.setValue(1,1,1) ;
  material->shininess.setValue(0.8F) ;

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(mesh1D) ;  
  root->addChild(myTextAttr) ;
  root->addChild(g2Axis) ;
  root->addChild(material) ;
  root->addChild(generalizedBar) ;

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Generalized Bar");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


