//
// PoGeneralizedScatter
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSphere.h>

#include <MeshViz/graph/PoGeneralizedScatter.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoIrregularMesh1D.h>
#include <MeshViz/nodes/PoPeriodFilter.h>
#include <MeshViz/nodes/PoMesh1DHints.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NP            14

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  float x[NP] = {0.5F, 1.5F, 1.8F, 2.4F, 3.2F, 4.5F, 6.3F, 6.9F, 8.0F, 8.5F, 9.0F,
                 9.5F, 9.8F, 10.F} ;
  float y[NP] = {0.5F, 3.8F, 1.2F, 1.9F, 6.3F, 7.2F, 9.3F, 7.2F, 6.0F, 6.3F, 7.5F, 
                 4.1F, 3.5F, 1.5F}  ;
  float sizes[NP] = {1, 2, 5, 1, 2, 5, 1, 2, 5, 1, 2, 5, 1, 2} ;

  SbColor colorList[3] = {SbColor(1,0,0), SbColor(0, 1, 0), SbColor(0, 0, 1)} ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoDomain *myDomain = new PoDomain ;  
  myDomain->min.setValue(0., 0., 0) ;
  myDomain->max.setValue(10., 10., 10.) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoSeparator *root = new SoSeparator ;

  PoIrregularMesh1D *mesh1D = new PoIrregularMesh1D ;
  mesh1D->setGeometry(NP, x) ;
  mesh1D->addValuesSet(0, y) ;
  mesh1D->addValuesSet(1, sizes) ;

  PoMesh1DHints *mesh1DHints = new PoMesh1DHints ;
  mesh1DHints->geomInterpretation = PoMesh1DHints::SMOOTH ;

  PoPeriodFilter *periodFilter = new PoPeriodFilter ;
  periodFilter->period = 0.5 ;

  SoMaterial *mat = new SoMaterial ;
  mat->diffuseColor.setValues(0, 3, colorList) ;

  SoSeparator *sphereSep = new SoSeparator ;
  sphereSep->addChild(new SoSphere) ;

  PoGeneralizedScatter *genScatter = new PoGeneralizedScatter ;
  genScatter->markers = sphereSep ;
  genScatter->sizeValuesIndex = 1 ;
  genScatter->material.setValue(mat) ;
  genScatter->scaleFactor.setValue(0.5, 0.5, 0.5) ;
  genScatter->colorBinding = PoChart::PER_VERTEX ;
  
  PoGroup2Axis *g2Axis = new 
    PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup2Axis::LINEAR, 
		 PoGroup2Axis::LINEAR, "X-Axis", "Y-Axis") ;

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(mesh1DHints) ;
  root->addChild(mesh1D) ;  
  root->addChild(myTextAttr) ;
  root->addChild(periodFilter) ;
  root->addChild(genScatter) ;
  root->addChild(g2Axis) ;

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Generalized Scatter");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


