#include "GraphAuditors.h"

#include <DialogViz/SoDialogVizAll.h>

void
GraphAuditor::dialogCheckBox( SoDialogCheckBox* cpt )
{
  // Graduation
  if ( cpt->auditorID.getValue() == "graduations_stringvisibility" )
  {
    m_axis->gradAddStringVisibility.setValue( cpt->state.getValue() );
  }
}

void
GraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  // Graduation
  if ( cpt->auditorID.getValue() == "graduations_fontsize" )
  {
    m_axis->gradFontSize.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "graduations_distanceaxis" )
  {
    m_axis->gradDistAxis.setValue( cpt->value.getValue() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_fontsize" )
  {
    m_axis->titleFontSize.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_distanceaxis" )
  {
    m_axis->titleDistAxis.setValue( cpt->value.getValue() );
  }

  // Margin
  else if ( cpt->auditorID.getValue() == "margin_start" )
  {
    m_axis->marginStart.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "margin_end" )
  {
    m_axis->marginEnd.setValue( cpt->value.getValue() );
  }

  // Grid
  else if ( cpt->auditorID.getValue() == "grid_lengthgrad" )
  {
    m_axis->gridLengthGradSide.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "grid_lengthgradother" )
  {
    m_axis->gridLengthGradOtherSide.setValue( cpt->value.getValue() );
  }

  // Arrow
  else if ( cpt->auditorID.getValue() == "arrow_height" )
  {
    m_axis->arrowHeight.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "arrow_length" )
  {
    m_axis->arrowLength.setValue( cpt->value.getValue() );
  }

  // Tick
  else if ( cpt->auditorID.getValue() == "tick_length" )
  {
    m_axis->tickMainLength.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "tick_sublength" )
  {
    m_axis->tickSubLength.setValue( cpt->value.getValue() );
  }
}

void
GraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "reverseflag" )
  {
    m_axis->reverseFlag.setValue( cpt->selectedItem.getValue() );
  }

  // Graduation
  else if ( cpt->auditorID.getValue() == "graduations_visibility" )
  {
    m_axis->gradVisibility.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "graduations_position" )
  {
    m_axis->gradPosition.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "graduations_path" )
  {
    m_axis->gradPath.setValue( cpt->selectedItem.getValue() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_visibility" )
  {
    m_axis->titleVisibility.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_position" )
  {
    m_axis->titlePosition.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_path" )
  {
    m_axis->titlePath.setValue( cpt->selectedItem.getValue() );
  }

  // Margin
  else if ( cpt->auditorID.getValue() == "margin_type" )
  {
    m_axis->marginType.setValue( cpt->selectedItem.getValue() );
  }

  // Grid
  else if ( cpt->auditorID.getValue() == "grid_visibility" )
  {
    m_axis->gridVisibility.setValue( cpt->selectedItem.getValue() );
  }

  // Arrow
  else if ( cpt->auditorID.getValue() == "arrow_visibility" )
  {
    m_axis->arrowVisibility.setValue( cpt->selectedItem.getValue() );
  }

  // Tick
  else if ( cpt->auditorID.getValue() == "tick_visibility" )
  {
    m_axis->tickVisibility.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "tick_position" )
  {
    m_axis->tickPosition.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "tick_subdefinition" )
  {
    m_axis->tickSubDef.setValue( cpt->selectedItem.getValue() );
  }
}

void
GraphAuditor::dialogEditText( SoDialogEditText* cpt )
{
  // Graduation
  if ( cpt->auditorID.getValue() == "graduations_string" )
  {
    m_axis->gradAddString.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "graduations_fontname" )
  {
    m_axis->gradFontName.setValue( cpt->editText.getValue() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_string" )
  {
    m_axis->titleString.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_fontname" )
  {
    m_axis->titleFontName.setValue( cpt->editText.getValue() );
  }
}

void
GraphAuditor::dialogIntegerSlider( SoDialogIntegerSlider* cpt )
{
  // Tick
  if ( cpt->auditorID.getValue() == "tick_numorperiod" )
  {
    m_axis->tickNumOrPeriod.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "tick_firstgrad" )
  {
    m_axis->tickFirstGrad.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "tick_lastgrad" )
  {
    m_axis->tickLastGrad.setValue( cpt->value.getValue() );
  }
}

/** Polar **/
void
PolarGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  // Polar
  if ( cpt->auditorID.getValue() == "polar_offset" )
  {
    m_polarAxis->offset.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "polar_startradius" )
  {
    m_polarAxis->startRadius.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "polar_endradius" )
  {
    m_polarAxis->endRadius.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "polar_theta" )
  {
    m_polarAxis->theta.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "polar_multfactordistaxis" )
  {
    m_polarAxis->multFactorDistAxis.setValue( cpt->value.getValue() );
  }

  GraphAuditor::dialogRealSlider( cpt );
}

void
PolarGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  // Polar
  if ( cpt->auditorID.getValue() == "polar_multfactorposition" )
  {
    m_polarAxis->multFactorPosition.setValue( cpt->selectedItem.getValue() );
  }

  GraphAuditor::dialogComboBox( cpt );
}

/** Polar Linear Axis **/
void
PolarLinearGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  // Polar lin
  if ( cpt->auditorID.getValue() == "polarlin_step" )
  {
    m_polarLinearAxis->step.setValue( cpt->value.getValue() );
  }

  PolarGraphAuditor::dialogRealSlider( cpt );
}

void
PolarLinearGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  // Polar lin
  if ( cpt->auditorID.getValue() == "polarlin_graduationfit" )
  {
    m_polarLinearAxis->gradFit.setValue( cpt->selectedItem.getValue() );
  }

  PolarGraphAuditor::dialogComboBox( cpt );
}

/** Polar Log Axis **/
void
PolarLogGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "log_fontsize" )
  {
    m_polarLogAxis->decadeFontSize.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_multfactordistaxis" )
  {
    m_polarLogAxis->multFactorDistAxis.setValue( cpt->value.getValue() );
  }

  PolarGraphAuditor::dialogRealSlider( cpt );
}

void
PolarLogGraphAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "log_decadelist" )
  {
    m_polarLogAxis->decadeList.deleteValues( 0, -1 );

    const SbString& baseString = cpt->editText.getValue();

    SbStringList list = SbStringList::split( baseString, " " );
    int listSize = list.getLength();

    // i = 1 because we skip the first part
    for ( int i = 1; i < listSize; i++ )
    {
      unsigned short x = (unsigned short) list[i]->toFloat();

      m_polarLogAxis->decadeList.set1Value( i, x );

      delete list[i];
    }
  }
  else if ( cpt->auditorID.getValue() == "log_fontname" )
  {
    m_polarLogAxis->decadeFontName.setValue( cpt->editText.getValue() );
  }

  PolarGraphAuditor::dialogEditText( cpt );
}

void
PolarLogGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "log_decadelistdef" )
  {
    m_polarLogAxis->decadeListDef.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_decaderep" )
  {
    m_polarLogAxis->decadeRep.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_tenpower" )
  {
    m_polarLogAxis->tenPowerRep.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_multfactorposition" )
  {
    m_polarLogAxis->multFactorPosition.setValue( cpt->selectedItem.getValue() );
  }

  PolarGraphAuditor::dialogComboBox( cpt );
}

/** Cartesian Axis **/
void
CartesianGraphAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "cartesian_start" )
  {
    float x = 0.0, y = 0.0, z = 0.0;

    const SbString& baseString = cpt->editText.getValue();

    SbStringList list = SbStringList::split( baseString, " " );
    const int listSize = list.getLength();

    if ( listSize >= 2 )
      x = list[1]->toFloat();

    if ( listSize >= 3 )
      y = list[2]->toFloat();

    if ( listSize >= 4 )
      z = list[3]->toFloat();

    for ( int i = 0; i < listSize; i++ )
      delete list[i];

    m_cartesianAxis->start.setValue( x, y, z );
  }
  else if ( cpt->auditorID.getValue() == "cartesian_end" )
  {
    const SbString& s = cpt->editText.getValue();

    if ( !s.isEmpty() )
      m_cartesianAxis->end.setValue( s.toFloat() );
  }

  GraphAuditor::dialogEditText( cpt );
}

void
CartesianGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "cartesian_type" )
  {
    m_cartesianAxis->type.setValue( cpt->selectedItem.getValue() );
  }

  GraphAuditor::dialogComboBox( cpt );
}

/** Cartesian Log Axis **/
void
LogGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "log_fontsize" )
  {
    m_logAxis->decadeFontSize.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_multfactordistaxis" )
  {
    m_logAxis->multFactorDistAxis.setValue( cpt->value.getValue() );
  }

  CartesianGraphAuditor::dialogRealSlider( cpt );
}

void
LogGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "log_decadelistdef" )
  {
    m_logAxis->decadeListDef.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_decaderep" )
  {
    m_logAxis->decadeRep.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_tenpower" )
  {
    m_logAxis->tenPowerRep.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "log_multfactorposition" )
  {
    m_logAxis->multFactorPosition.setValue( cpt->selectedItem.getValue() );
  }

  CartesianGraphAuditor::dialogComboBox( cpt );
}

void
LogGraphAuditor::dialogEditText( SoDialogEditText* cpt )
{

  if ( cpt->auditorID.getValue() == "log_decadelist" )
  {
    m_logAxis->decadeList.deleteValues( 0, -1 );

    const SbString& baseString = cpt->editText.getValue();
    SbStringList list = SbStringList::split( baseString, " " );

    // i = 1 because we skip the first part
    for ( int i = 1; i < list.getLength(); i++ )
    {
      unsigned short x = (unsigned short) list[i]->toFloat();
      m_logAxis->decadeList.set1Value( i, x );
      delete list[i];
    }
  }
}

/** Cartesian Linear Axis **/
void
LinearGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "linear_step" )
  {
    m_linAxis->step.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "linear_multfactordistaxis" )
  {
    m_linAxis->multFactorDistAxis.setValue( cpt->value.getValue() );
  }

  CartesianGraphAuditor::dialogRealSlider( cpt );
}

void
LinearGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "linear_graduationfit" )
  {
    m_linAxis->gradFit.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "linear_multfactorposition" )
  {
    m_linAxis->multFactorPosition.setValue( cpt->selectedItem.getValue() );
  }

  CartesianGraphAuditor::dialogComboBox( cpt );
}

/** Time Axis **/
void
TimeGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "time_type" )
  {
    m_timeAxis->type.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "time_language" )
  {
    m_timeAxis->language.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "time_graduationfit" )
  {
    m_timeAxis->gradFit.setValue( cpt->selectedItem.getValue() );
  }

  GraphAuditor::dialogComboBox( cpt );
}

void
TimeGraphAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "time_start" )
  {
    m_timeAxis->startDate.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "time_end" )
  {
    m_timeAxis->endDate.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "time_coordinate" )
  {
    m_timeAxis->coord.setValue( cpt->editText.getValue().toFloat() );
  }
  else if ( cpt->auditorID.getValue() == "time_period" )
  {
    m_timeAxis->timesPeriod.setValue( cpt->editText.getValue() );
  }

  GraphAuditor::dialogEditText( cpt );
}

/** Angular Axis **/
void
AngularGraphAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "angular_offset" )
  {
    m_angularAxis->offset.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "angular_startangle" )
  {
    m_angularAxis->startAngle.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "angular_endangle" )
  {
    m_angularAxis->endAngle.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "angular_radius" )
  {
    m_angularAxis->radius.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "angular_anglestep" )
  {
    m_angularAxis->angleStep.setValue( cpt->value.getValue() );
  }

  GraphAuditor::dialogRealSlider( cpt );
}

void
AngularGraphAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "angular_graduationfit" )
  {
    m_angularAxis->gradFit.setValue( cpt->selectedItem.getValue() );
  }

  GraphAuditor::dialogComboBox( cpt );
}

/** Legend **/
void
LegendAuditor::dialogCheckBox( SoDialogCheckBox* cpt )
{
  // Values
  if ( cpt->auditorID.getValue() == "values_stringvisibility" )
  {
    m_legend->valueAddStringVisibility.setValue( cpt->state.getValue() );
  }
}

void
LegendAuditor::dialogRealSlider( SoDialogRealSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "boxratio" )
  {
    m_legend->boxRatio.setValue( cpt->value.getValue() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_fontsize" )
  {
    m_legend->titleFontSize.setValue( cpt->value.getValue() );
  }

  // Margin
  else if ( cpt->auditorID.getValue() == "margin_left" )
  {
    m_legend->marginLeft.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "margin_right" )
  {
    m_legend->marginRight.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "margin_bottom" )
  {
    m_legend->marginBottom.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "margin_top" )
  {
    m_legend->marginTop.setValue( cpt->value.getValue() );
  }
}

void
LegendAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "incrementtype" )
  {
    m_legend->incrementType.setValue( cpt->selectedItem.getValue() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_visibility" )
  {
    m_legend->titleVisibility.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_position" )
  {
    m_legend->titlePosition.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_textpath" )
  {
    m_legend->titlePath.setValue( cpt->selectedItem.getValue() );
  }

  // Values
  else if ( cpt->auditorID.getValue() == "values_visibility" )
  {
    m_legend->valueVisibility.setValue( cpt->selectedItem.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "values_position" )
  {
    m_legend->valuePosition.setValue( cpt->selectedItem.getValue() );
  }

  // Margin
  else if ( cpt->auditorID.getValue() == "margin_type" )
  {
    m_legend->marginType.setValue( cpt->selectedItem.getValue() );
  }
}

void
LegendAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "columnscount" )
  {
    m_legend->numColumns.setValue( cpt->editText.getValue().toInt() );
  }

  // Title
  else if ( cpt->auditorID.getValue() == "title_fontname" )
  {
    m_legend->titleFontName.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "title_string" )
  {
    m_legend->titleString.setValue( cpt->editText.getValue() );
  }

  // Values
  else if ( cpt->auditorID.getValue() == "values_fontname" )
  {
    m_legend->valueFontName.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "values_string" )
  {
    m_legend->valueAddString.setValue( cpt->editText.getValue() );
  }
}

/** Item Legend **/
void
LegendItemAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "item_start" )
  {
    m_itemLegend->start.setValue( static_cast<float>(cpt->editText.getValue().toInt()) );
  }
  else if ( cpt->auditorID.getValue() == "item_end" )
  {
	  m_itemLegend->end.setValue(static_cast<float>(cpt->editText.getValue().toInt()));
  }

  LegendAuditor::dialogEditText( cpt );
}

void
LegendItemAuditor::dialogCheckBox( SoDialogCheckBox* cpt )
{
  if ( cpt->auditorID.getValue() == "item_boxvisibility" )
  {
    m_itemLegend->boxVisibility.setValue( cpt->state.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "item_linevisibility" )
  {
    m_itemLegend->lineVisibility.setValue( cpt->state.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "item_markervisibility" )
  {
    m_itemLegend->markerVisibility.setValue( cpt->state.getValue() );
  }

  LegendAuditor::dialogCheckBox( cpt );
}

void
LegendValueAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "value_undefupper" )
  {
    m_valueLegend->upperUndefString.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "value_undeflower" )
  {
    m_valueLegend->lowerUndefString.setValue( cpt->editText.getValue() );
  }

  LegendAuditor::dialogEditText( cpt );
}

void
LegendValueAuditor::dialogIntegerSlider( SoDialogIntegerSlider* cpt )
{
  if ( cpt->auditorID.getValue() == "value_period" )
  {
    m_valueLegend->periodValue.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "value_first" )
  {
    m_valueLegend->firstValue.setValue( cpt->value.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "value_last" )
  {
    m_valueLegend->lastValue.setValue( cpt->value.getValue() );
  }

  LegendAuditor::dialogIntegerSlider( cpt );
}

void
LegendAutoValueAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "auto_start" )
  {
    float x = 0.0, y = 0.0;
    const SbString& baseString = cpt->editText.getValue();

    SbStringList list = SbStringList::split( baseString, " " );
    int listSize = list.getLength();

    if ( listSize >= 2 )
      x = list[1]->toFloat();

    if ( listSize >= 3 )
      y = list[2]->toFloat();

    for ( int i = 0; i < listSize; i++ )
      delete list[i];

    m_autoValueLegend->start.setValue( x, y );
  }
  else if ( cpt->auditorID.getValue() == "auto_end" )
  {
    float x = 0.0, y = 0.0;

    const SbString& baseString = cpt->editText.getValue();

    SbStringList list = SbStringList::split( baseString, " " );
    int listSize = list.getLength();

    if ( listSize >= 2 )
      x = list[1]->toFloat();

    if ( listSize >= 3 )
      y = list[2]->toFloat();

    for ( int i = 0; i < listSize; i++ )
      delete list[i];

    m_autoValueLegend->end.setValue( x, y );
  }
  LegendValueAuditor::dialogEditText( cpt );
}

void
LegendLinearValueAuditor::dialogComboBox( SoDialogComboBox* cpt )
{
  if ( cpt->auditorID.getValue() == "linear_visibility" )
  {
    m_linearValueLegend->valueDistribution.setValue( cpt->selectedItem.getValue() );
  }

  LegendValueAuditor::dialogComboBox( cpt );
}

void
LegendNonLinearValueAuditor::dialogEditText( SoDialogEditText* cpt )
{
  if ( cpt->auditorID.getValue() == "nonlinear_less" )
  {
    m_nonlinearValueLegend1->lessLevelString.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "nonlinear_greater" )
  {
    m_nonlinearValueLegend1->greaterLevelString.setValue( cpt->editText.getValue() );
  }
  else if ( cpt->auditorID.getValue() == "nonlinear_separator" )
  {
    m_nonlinearValueLegend1->valueSeparatorString.setValue( cpt->editText.getValue() );
  }

  LegendAutoValueAuditor::dialogEditText( cpt );
}
