#ifndef GraphAuditor_H
#define GraphAuditor_H

#include <DialogViz/auditors/SoDialogAuditor.h>

#include <MeshViz/graph/PoLegend.h>
#include <MeshViz/graph/PoItemLegend.h>
#include <MeshViz/graph/PoValueLegend.h>
#include <MeshViz/graph/PoAutoValueLegend.h>
#include <MeshViz/graph/PoLinearValueLegend.h>
#include <MeshViz/graph/PoNonLinearValueLegend1.h>

#include <MeshViz/graph/PoAxis.h>
#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoTimeAxis.h>
#include <MeshViz/graph/PoAngularAxis.h>
#include <MeshViz/graph/PoPolarAxis.h>
#include <MeshViz/graph/PoPolarLinAxis.h>
#include <MeshViz/graph/PoPolarLogAxis.h>

class GraphAuditor : public SoDialogAuditor
{
public:
  GraphAuditor( PoAxis* axis )
    : m_axis( axis )
  {
  }

protected:
  virtual void dialogCheckBox( SoDialogCheckBox* cpt );
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
  virtual void dialogEditText( SoDialogEditText* cpt );
  virtual void dialogIntegerSlider( SoDialogIntegerSlider* cpt );

  PoAxis* m_axis;
};

class PolarGraphAuditor : public GraphAuditor
{
public:
  PolarGraphAuditor( PoPolarAxis* polarAxis )
    : GraphAuditor( polarAxis )
    , m_polarAxis( polarAxis )
  {
  }

private:
  PoPolarAxis* m_polarAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class PolarLinearGraphAuditor : public PolarGraphAuditor
{
public:
  PolarLinearGraphAuditor( PoPolarLinAxis* polarLinAxis )
    : PolarGraphAuditor( polarLinAxis )
    , m_polarLinearAxis( polarLinAxis )
  {
  }

private:
  PoPolarLinAxis* m_polarLinearAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class PolarLogGraphAuditor : public PolarGraphAuditor
{
public:
  PolarLogGraphAuditor( PoPolarLogAxis* polarLogAxis )
    : PolarGraphAuditor( polarLogAxis )
    , m_polarLogAxis( polarLogAxis )
  {
  }

private:
  PoPolarLogAxis* m_polarLogAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogEditText( SoDialogEditText* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class CartesianGraphAuditor : public GraphAuditor
{
public:
  CartesianGraphAuditor( PoCartesianAxis* cartesianAxis )
    : GraphAuditor( cartesianAxis )
    , m_cartesianAxis( cartesianAxis )
  {
  }

protected:
  virtual void dialogEditText( SoDialogEditText* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );

  PoCartesianAxis* m_cartesianAxis;
};

class LogGraphAuditor : public CartesianGraphAuditor
{
public:
  LogGraphAuditor( PoLogAxis* logAxis )
    : CartesianGraphAuditor( logAxis )
    , m_logAxis( logAxis )
  {
  }

private:
  PoLogAxis* m_logAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
  virtual void dialogEditText( SoDialogEditText* cpt );
};

class LinearGraphAuditor : public CartesianGraphAuditor
{
public:
  LinearGraphAuditor( PoLinearAxis* linearAxis )
    : CartesianGraphAuditor( linearAxis )
    , m_linAxis( linearAxis )
  {
  }

  void
  setAxis( PoLinearAxis* linearAxis )
  {
    m_linAxis = linearAxis;
    m_cartesianAxis = linearAxis;
    m_axis = linearAxis;
  }

private:
  PoLinearAxis* m_linAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class TimeGraphAuditor : public GraphAuditor
{
public:
  TimeGraphAuditor( PoTimeAxis* timeAxis )
    : GraphAuditor( timeAxis )
    , m_timeAxis( timeAxis )
  {
  }

private:
  PoTimeAxis* m_timeAxis;

protected:
  virtual void dialogComboBox( SoDialogComboBox* cpt );
  virtual void dialogEditText( SoDialogEditText* cpt );
};

class AngularGraphAuditor : public GraphAuditor
{
public:
  AngularGraphAuditor( PoAngularAxis* angularAxis )
    : GraphAuditor( angularAxis )
    , m_angularAxis( angularAxis )
  {
  }

private:
  PoAngularAxis* m_angularAxis;

protected:
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class LegendAuditor : public SoDialogAuditor
{
public:
  LegendAuditor( PoLegend* legend )
    : m_legend( legend )
  {
  }

protected:
  virtual void dialogCheckBox( SoDialogCheckBox* cpt );
  virtual void dialogRealSlider( SoDialogRealSlider* cpt );
  virtual void dialogComboBox( SoDialogComboBox* cpt );
  virtual void dialogEditText( SoDialogEditText* cpt );

  PoLegend* m_legend;
};

class LegendItemAuditor : public LegendAuditor
{
public:
  LegendItemAuditor( PoItemLegend* itemLegend )
    : LegendAuditor( itemLegend )
    , m_itemLegend( itemLegend )
  {
  }

private:
  PoItemLegend* m_itemLegend;

protected:
  virtual void dialogEditText( SoDialogEditText* cpt );
  virtual void dialogCheckBox( SoDialogCheckBox* cpt );
};

class LegendValueAuditor : public LegendAuditor
{
public:
  LegendValueAuditor( PoValueLegend* valueLegend )
    : LegendAuditor( valueLegend )
    , m_valueLegend( valueLegend )
  {
  }

private:
  PoValueLegend* m_valueLegend;

protected:
  virtual void dialogEditText( SoDialogEditText* cpt );
  virtual void dialogIntegerSlider( SoDialogIntegerSlider* cpt );
};

class LegendAutoValueAuditor : public LegendValueAuditor
{
public:
  LegendAutoValueAuditor( PoAutoValueLegend* autoValueLegend )
    : LegendValueAuditor( autoValueLegend )
    , m_autoValueLegend( autoValueLegend )
  {
  }

private:
  PoAutoValueLegend* m_autoValueLegend;

protected:
  virtual void dialogEditText( SoDialogEditText* cpt );
};

class LegendLinearValueAuditor : public LegendAutoValueAuditor
{
public:
  LegendLinearValueAuditor( PoLinearValueLegend* linearValueLegend )
    : LegendAutoValueAuditor( linearValueLegend )
    , m_linearValueLegend( linearValueLegend )
  {
  }

private:
  PoLinearValueLegend* m_linearValueLegend;

protected:
  virtual void dialogComboBox( SoDialogComboBox* cpt );
};

class LegendNonLinearValueAuditor : public LegendAutoValueAuditor
{
public:
  LegendNonLinearValueAuditor( PoNonLinearValueLegend1* nonlinearValueLegend1 )
    : LegendAutoValueAuditor( nonlinearValueLegend1 )
    , m_nonlinearValueLegend1( nonlinearValueLegend1 )
  {
  }

private:
  PoNonLinearValueLegend1* m_nonlinearValueLegend1;

protected:
  virtual void dialogEditText( SoDialogEditText* cpt );
};
#endif // GraphAuditor_H
