#include "GraphEditors.h"

#include <DialogViz/SoDialogVizAll.h>

SoTopLevelDialog*
GraphEditors::createAxisEditor()
{
  return createBaseEditor( "$OIVHOME/examples/source/MeshViz/graph/graphEditors/AxisEditor.iv" );
}

SoTopLevelDialog*
GraphEditors::createCartesianAxisEditor()
{
  return createEditor( GraphEditors::createAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/CartesianAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createLogAxisEditor()
{
  return createEditor( GraphEditors::createCartesianAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/LogAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createLinearAxisEditor()
{
  return createEditor( GraphEditors::createCartesianAxisEditor(),
                       "$OIVHOME/examples/source/MeshViz/graph/graphEditors/LinearAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createPolarAxisEditor()
{
  return createEditor( GraphEditors::createAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/PolarAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createPolarLinAxisEditor()
{
  return createEditor( GraphEditors::createPolarAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/PolarLinTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createPolarLogAxisEditor()
{
  return createEditor( GraphEditors::createPolarAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/LogAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createTimeAxisEditor()
{
  return createEditor( GraphEditors::createAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/TimeAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createAngularAxisEditor()
{
  return createEditor( GraphEditors::createAxisEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/AngularAxisTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createLegendEditor()
{
  return createBaseEditor( "$OIVHOME/examples/source/MeshViz/graph/graphEditors/LegendEditor.iv" );
}

SoTopLevelDialog*
GraphEditors::createItemLegendEditor()
{
  return createEditor( GraphEditors::createLegendEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/ItemLegendTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createValueLegendEditor()
{
  return createEditor( GraphEditors::createLegendEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/ValueLegendTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createAutoValueLegendEditor()
{
  return createEditor( GraphEditors::createValueLegendEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/AutoValueLegendTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createLinearValueLegendEditor()
{
  return createEditor( GraphEditors::createAutoValueLegendEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/LinearValueLegendTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createNonLinearValueLegend1Editor()
{
  return createEditor( GraphEditors::createAutoValueLegendEditor(), "$OIVHOME/examples/source/MeshViz/graph/graphEditors/NonLinearValueLegendTab.iv" );
}

SoTopLevelDialog*
GraphEditors::createEditor( SoTopLevelDialog* base, const SbString& tabFileName )
{
  SoDialogComponent* tab = NULL;

  SoInput myInput;
  if ( !myInput.openFile( tabFileName ) )
    return NULL;
  SoGroup* myDialogGroup = SoDB::readAll( &myInput );
  // if the tab cannot be loaded, return the base editor
  if ( !myDialogGroup )
    return base;
  myDialogGroup->ref();

  tab = (SoDialogComponent*) myDialogGroup->getChild( 0 );

  SoRowDialog* row = (SoRowDialog*) base->getChild( 0 );
  SoTabDialog* tabDialog = (SoTabDialog*) row->getChild( 1 );
  tabDialog->addChild( tab );

  return base;
}

SoTopLevelDialog*
GraphEditors::createBaseEditor( const SbString& fileName )
{
  SoInput myInput;
  if ( !myInput.openFile( fileName ) )
    return NULL;
  SoGroup* myDialogGroup = SoDB::readAll( &myInput );
  if ( !myDialogGroup )
    return NULL;
  myDialogGroup->ref();
  SoTopLevelDialog* editor = (SoTopLevelDialog*) myDialogGroup->getChild( 0 );
  return editor;
}
