#ifndef GraphEditors_H
#define GraphEditors_H

#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoTabDialog.h>

class GraphEditors
{
public:
  static SoTopLevelDialog* createAxisEditor();

  static SoTopLevelDialog* createCartesianAxisEditor();
  static SoTopLevelDialog* createLogAxisEditor();
  static SoTopLevelDialog* createLinearAxisEditor();

  static SoTopLevelDialog* createPolarAxisEditor();
  static SoTopLevelDialog* createPolarLinAxisEditor();
  static SoTopLevelDialog* createPolarLogAxisEditor();

  static SoTopLevelDialog* createTimeAxisEditor();
  static SoTopLevelDialog* createAngularAxisEditor();

  static SoTopLevelDialog* createLegendEditor();
  static SoTopLevelDialog* createItemLegendEditor();
  static SoTopLevelDialog* createValueLegendEditor();
  static SoTopLevelDialog* createAutoValueLegendEditor();
  static SoTopLevelDialog* createLinearValueLegendEditor();
  static SoTopLevelDialog* createNonLinearValueLegend1Editor();

private:
  /**
   * @brief Internal helper to create an editor from a base and add a tab to it.
   * This relies heavily on the layout of the AxisEditor.iv file
   * @param base The SoTopLevelDialog to which a tab must be added
   * @param tabFileName the file from which to retrieve a tab and add to the editor
   * @return An editor comprised of tabs, the one passed being the last one.
   */
  static SoTopLevelDialog* createEditor( SoTopLevelDialog* base, const SbString& tabFileName );

  static SoTopLevelDialog* createBaseEditor( const SbString& fileName );
};

#endif // GraphEditors_H
