//
//  PoGroup2Axis
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoGroup2Axis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;

   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(0., 0.,0) ;
   myDomain->max.setValue(1., 10.,0) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   PoGroup2Axis *g2Axis = new 
     PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(1., 10.), PoGroup2Axis::LINEAR, 
		  PoGroup2Axis::LOGARITHMIC, "X-Axis", "Y-Axis") ;

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;
   root->addChild(g2Axis) ;
   
   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Group 2 axis");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


