//
// PoGroup3Axis3
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/nodes/SoAnnoText3Property.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoRotation.h>

#include <Inventor/nodekits/SoAppearanceKit.h>

#include <Inventor/events/SoKeyboardEvent.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoGroup3Axis3.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define CUR_TEXT_TITLE "Cur. Text : "
enum IvTextType {
  VECTOR_TEXT,
  VECTOR_OUTLINE_TEXT,
  VECTOR_STROKE_TEXT,
  RASTER_TEXT,
  NB_TEXT_TYPE
} ;

static const char *TextNames[NB_TEXT_TYPE] = {
  "Vector",
  "Vector outline",
  "Stroke",
  "Bitmap"
} ;

IvTextType CurTextType ;
SoAnnoText3Property *AnnoTextProp ;
PoMiscTextAttr *MyTextAttr ;

PoLinearAxis *XAxis, *YAxis, *ZAxis ;
SoText2      *InfoText ;
SoSwitch     *InfoSwitch ;

/*---------------------------------------------------------------------------*/

SoSwitch*
displayInfo() 
{
	// Informations
	SoSwitch *infoSwitch = new SoSwitch ;
	infoSwitch->ref() ;
	infoSwitch->whichChild = SO_SWITCH_ALL ;

	SoSeparator *infoSep = new SoSeparator ;

  SoOrthographicCamera *cam = new SoOrthographicCamera ;
  infoSep->addChild(cam) ;
  cam->viewportMapping = SoOrthographicCamera::LEAVE_ALONE ;
  cam->position.setValue(SbVec3f(0.005f,0.005f,1)) ;
  cam->height = 0.01f ;

	SoPickStyle *pickStyle = new SoPickStyle ;
	pickStyle->style = SoPickStyle::UNPICKABLE ;
	infoSep->addChild(pickStyle) ;

	infoSwitch->addChild(infoSep) ;

	SoLightModel *lModel = new SoLightModel ;
	lModel->model = SoLightModel::BASE_COLOR ;
	infoSep->addChild(lModel) ;

	SoFont *fontInfo = new SoFont ;
	fontInfo->name = "Courier New" ;
	fontInfo->size = 12 ;
	infoSep->addChild(fontInfo) ;

	SoBaseColor *infoColor = new SoBaseColor ;
	infoColor->rgb.setValue(SbColor(1, 1, 0.f)) ;
	infoSep->addChild(infoColor) ;

	SoTranslation *transInfo = new SoTranslation ;
	transInfo->translation.setValue(0.00025f, 0.00975f, 0.) ;
	infoSep->addChild(transInfo) ;

	InfoText = new SoText2 ;
  InfoText->string.set1Value(0, "H         : Toggle this display") ;
	InfoText->string.set1Value(1, "T         : Change the kind of text") ;
  SbString str(CUR_TEXT_TITLE) ;
  str += TextNames[CurTextType] ;
  InfoText->string.set1Value(2, str) ;
	infoSep->addChild(InfoText) ;

	infoSwitch->unrefNoDelete() ;
	return infoSwitch ;
}/*---------------------------------------------------------------------------*/

void 
myKeyPressCB (void *, SoEventCallback *eventCB) 
{
  const SoEvent *event = eventCB->getEvent();

  if (SO_KEY_PRESS_EVENT(event, T)) {
    CurTextType = (IvTextType)(((int)CurTextType + 1) % NB_TEXT_TYPE) ;

    if(CurTextType != VECTOR_STROKE_TEXT)
#ifdef _WIN32
      MyTextAttr->fontName = "Courier New"  ;
#else
      MyTextAttr->fontName = "Courier"  ;
#endif

    if(CurTextType != VECTOR_OUTLINE_TEXT) {
      XAxis->set("mainGradTextApp.drawStyle", "style FILLED") ;
      YAxis->set("mainGradTextApp.drawStyle", "style FILLED") ;
      ZAxis->set("mainGradTextApp.drawStyle", "style FILLED") ;
      
      XAxis->set("titleApp.drawStyle", "style FILLED") ;
      YAxis->set("titleApp.drawStyle", "style FILLED") ;
      ZAxis->set("titleApp.drawStyle", "style FILLED") ;
    }

    switch(CurTextType) {
    case VECTOR_TEXT:
      AnnoTextProp->renderPrintType = SoAnnoText3Property::RENDER3D_PRINT_VECTOR ;
      break ;

    case VECTOR_OUTLINE_TEXT:
      AnnoTextProp->renderPrintType = SoAnnoText3Property::RENDER3D_PRINT_VECTOR ;
      XAxis->set("mainGradTextApp.drawStyle", "style LINES") ;
      YAxis->set("mainGradTextApp.drawStyle", "style LINES") ;
      ZAxis->set("mainGradTextApp.drawStyle", "style LINES") ;
      
      XAxis->set("titleApp.drawStyle", "style LINES") ;
      YAxis->set("titleApp.drawStyle", "style LINES") ;
      ZAxis->set("titleApp.drawStyle", "style LINES") ;
      break ;

    case VECTOR_STROKE_TEXT:
      AnnoTextProp->renderPrintType = SoAnnoText3Property::RENDER3D_PRINT_VECTOR ;
      MyTextAttr->fontName = "TGS_Simplex_Roman" ;
      break ;

    case RASTER_TEXT:
      AnnoTextProp->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER ;
      break ;
    default:
      break;
    }
    SbString str(CUR_TEXT_TITLE) ;
    str+=TextNames[CurTextType] ;
    InfoText->string.set1Value(2, str) ;
  }
  else if (SO_KEY_PRESS_EVENT(event, H)) {
    if(InfoSwitch->whichChild.getValue() == SO_SWITCH_ALL)
       InfoSwitch->whichChild = SO_SWITCH_NONE ;
     else
       InfoSwitch->whichChild = SO_SWITCH_ALL ;   
  }
}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   CurTextType = VECTOR_TEXT ;
   SoSeparator *root = new SoSeparator ;

   // Track the keyboard events
   SoEventCallback *myEventCB = new SoEventCallback;
   myEventCB->addEventCallback(SoKeyboardEvent::getClassTypeId(),
                               myKeyPressCB, NULL);
   root->addChild(myEventCB) ;

   // Display Info
   InfoSwitch = displayInfo() ;
   root->addChild(InfoSwitch) ;

   SoPerspectiveCamera *camera = new SoPerspectiveCamera ;
   root->addChild(camera) ;

   SoRotation *rotation = new SoRotation ;
   SbRotation rotX(SbVec3f(1,0,0), (float)(M_PI / 8.0)) ;
   SbRotation rotY(SbVec3f(0,1,0), (float)(-M_PI / 5.0)) ;
   rotation->rotation.setValue(rotY*rotX); 
   root->addChild(rotation) ;

   AnnoTextProp = new SoAnnoText3Property ;

   root->addChild(AnnoTextProp) ;

   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(0., 0., 0.) ;
   myDomain->max.setValue(1, 10, 100) ;

   MyTextAttr = new PoMiscTextAttr ;
#ifdef _WIN32
   MyTextAttr->fontName = "Courier New"  ;
#else
   MyTextAttr->fontName = "Courier"  ;
#endif

   PoGroup3Axis3 *g3Axis  = new 
     PoGroup3Axis3(SbVec3f(0.,0.,0.), SbVec3f(1., 10., 100.), PoGroup3Axis3::LINEAR,
		               PoGroup3Axis3::LINEAR, PoGroup3Axis3::LINEAR, PoGroup3Axis3::Z_AXIS, 
                   "X", "Y", "Z") ;
   g3Axis->verticalAxisName = PoGroup3Axis3::Y_AXIS ;

   XAxis = SO_GET_PART(g3Axis, "xAxis", PoLinearAxis) ;
   YAxis = SO_GET_PART(g3Axis, "yAxis", PoLinearAxis) ;
   ZAxis = SO_GET_PART(g3Axis, "zAxis", PoLinearAxis) ;

   XAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   YAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   ZAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;

   XAxis->gradFontSize = 0.06f ;
   YAxis->gradFontSize = 0.06f ;
   ZAxis->gradFontSize = 0.06f ;

   XAxis->tickFirstGrad = 2 ;

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(MyTextAttr) ;
   root->addChild(g3Axis) ;

   SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setCamera(camera) ;
   //viewer->setSize(SbVec2s(500,500)) ;
   viewer->setTitle("Group 3 axis 3");
   viewer->show();
   viewer->viewAll();

   SbVec3f camPos = camera->position.getValue() ;
   camera->position.setValue(camPos[0], camPos[1], camPos[2]-camPos[2]*0.4f)  ;

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


