//
// PoGroup4Axis
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoGroup4Axis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(0., 0.,0) ;
   myDomain->max.setValue(10., 10.,1) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   PoGroup4Axis *g4Axis  = new 
     PoGroup4Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup4Axis::LINEAR, 
		  PoGroup4Axis::LOGARITHMIC, "X-Axis", "Y-Axis") ;

   PoLinearAxis *xAxis = SO_GET_PART(g4Axis, "xUpAxis", PoLinearAxis) ;
   PoLogAxis    *yAxis = SO_GET_PART(g4Axis, "yLeftAxis", PoLogAxis) ;
   PoLinearAxis *x2Axis = SO_GET_PART(g4Axis, "xDownAxis", PoLinearAxis) ;
   PoLogAxis    *y2Axis = SO_GET_PART(g4Axis, "yRightAxis", PoLogAxis) ;

   xAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   yAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   x2Axis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   y2Axis->set("bodyApp.material", "diffuseColor 1 0 0") ;

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;
   root->addChild(g4Axis) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Group 4 axis");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


