//
// PoGroup6Axis3
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTranslation.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoGroup6Axis3.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;

   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(0., 0., 0.) ;
   myDomain->max.setValue(1., 10., 100) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;

   PoGroup6Axis3 *g6Axis  = new 
     PoGroup6Axis3(SbVec3f(0.,0.,0.), SbVec3f(1., 10., 100.), PoGroup6Axis3::LINEAR,
		   PoGroup6Axis3::LOGARITHMIC, PoGroup6Axis3::LINEAR, "X", "Y", "Z") ;

   PoLinearAxis *xAxis  = SO_GET_PART(g6Axis, "xUpAxis", PoLinearAxis) ;
   PoLinearAxis *x2Axis = SO_GET_PART(g6Axis, "xDownAxis", PoLinearAxis) ;
   PoLogAxis    *yAxis  = SO_GET_PART(g6Axis, "yLeftAxis", PoLogAxis) ;
   PoLogAxis    *y2Axis = SO_GET_PART(g6Axis, "yRightAxis", PoLogAxis) ;
   PoLinearAxis *zAxis  = SO_GET_PART(g6Axis, "zDownAxis", PoLinearAxis) ;
   PoLinearAxis *z2Axis = SO_GET_PART(g6Axis, "zUpAxis", PoLinearAxis) ;

   xAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   yAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   zAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   x2Axis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   y2Axis->set("bodyApp.material", "diffuseColor 1 0 0") ;
   z2Axis->set("bodyApp.material", "diffuseColor 1 0 0") ;

   SoCube *cube = new SoCube ;
   cube->width = 0.2F ;
   cube->height = 3 ;
   cube->depth = 30 ;
   SoTranslation *translate = new SoTranslation ;
   translate->translation.setValue(0.5, 5, 50) ;

   root->ref() ;
   root->addChild(g6Axis) ;
   root->addChild((SoNode*)myDomain->getTransform()) ;
   root->addChild(translate) ;
   root->addChild(cube) ;

   SoXtExaminerViewer *viewer = 
     new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Group 6 axis");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


