//
// PoHighLowClose
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoHighLowClose.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  static float valX[5]    =  {0.0F, 1.0F, 2.0F, 3.0F, 4.0F} ;
  static float valHigh[5] =  {1.0F, 4.0F, 5.0F, 7.0F, 4.0F} ;
  static float valLow[5] =   {-1.0F, 2.0F, 3.0F, 0.0F, 3.0F} ;
  static float valClose[5] = {0.0F, 3.5F, 4.5F, 2.0F,  3.3F} ;

   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoHighLowClose *hlc = new PoHighLowClose(5, valX, valHigh, valLow, valClose) ;
   
   root->ref() ;
   root->addChild(hlc) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("High Low Close");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


