//
// PoItemLegend
//
////////////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>


#include <MeshViz/graph/PoItemLegend.h>

#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NUM_VAL 8

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

#include <GraphAuditors.h>
#include <GraphEditors.h>

int  main(int, char **argv)
{
  static const char *items[] = {
    "Bordeaux",
    "Los Angeles",
    "Paris",
    "Madrid",
    "San Diego",
    "London",
    "Rome",
    "New York",
    "San Francisco",
    "Montreal"      
  } ;

  SbColor colors[10] = {SbColor(1.F, 0.F, 0.F), SbColor(0.F, 1.F, 0.F), SbColor(0.F, 0.F, 1.F),
			SbColor(0.F, 1.F, 1.F), SbColor(1.F, 0.F, 1.F), SbColor(1.F, 1.F, 0.F),
			SbColor(0.5F, 0.5F, 0.5F), SbColor(1.F, 1.F, 1.F), SbColor(0.2F, 0.4F, 0.8F),
			SbColor(0.7F, 0.6F, 0.3F) } ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();

  SoAnnotation *root = new SoAnnotation ;
  root->ref();

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";

  root->addChild(myTextAttr) ;
  
  PoItemLegend *legend = new PoItemLegend(SbVec2f(0.,0.), SbVec2f(0.5, 1.0), 10, items) ;
  legend->titleString.setValue("Cities") ;
  legend->titleFontSize = 0.075F ;
  legend->titleVisibility = PoItemLegend::VISIBILITY_ON ;
  legend->boxColor.setValues(0, 10, colors) ;
  legend->boxRatio = 2. ;
  legend->incrementType = PoItemLegend::VERTICAL_INCREMENT ;
  legend->set("backgroundApp.material", "diffuseColor 0 0 0") ;
  legend->set("backgroundBorderApp.material", "diffuseColor 1 0 0") ;

  root->addChild(legend) ;

  // Create axis editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createItemLegendEditor();

  LegendItemAuditor* myAuditor = new LegendItemAuditor( legend );

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();

  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Item legend");
  viewer->show();
  viewer->viewAll();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  root->unref();
  delete viewer;
  editor = NULL;
  delete myAuditor;

  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/
