//
// PoLabelField
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCone.h>

#include <MeshViz/graph/PoLabelField.h>
#include <MeshViz/graph/PoGroup2Axis.h>

#include <MeshViz/nodes/PoDomain.h>

#define NB_LABELS    10

static float values[NB_LABELS] = {
  1.2665F, 3.45F, 7.5F, 89.99F, 12.F, 
  11.55F, 789.3F, 3.31416F, 5.5F, 2.F
} ;

static const char *strings[NB_LABELS] = {
  "Point 1", "Point 2", "Point 3", "Point 4", "Point 5", 
  "Point 6", "Point 7", "Point 8", "Point 9", "Point 10"
} ;

static SbVec2f points[NB_LABELS] = {
  SbVec2f(0.1F,1.F), SbVec2f(0.2F,2.F), SbVec2f(0.3F,3.F), 
  SbVec2f(0.4F,4.F), SbVec2f(0.5F,5.F), SbVec2f(0.6F,6.F),
  SbVec2f(0.7F,7.F), SbVec2f(0.8F,8.F), SbVec2f(0.9F,9.F), 
  SbVec2f(0.95F,10.F)
} ;

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;


  SoSeparator *root = new SoSeparator ;

  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(0., 0.,0) ;
  myDomain->max.setValue(1., 10.,0) ;

  PoGroup2Axis *group2Axis = new PoGroup2Axis(SbVec2f(0., 0.), SbVec2f(1., 10.),
					      PoGroup2Axis::LINEAR, PoGroup2Axis::LINEAR) ;
  PoLabelField *labelFld = new PoLabelField(NB_LABELS, points, (const char**)strings, values, 0.04F) ;
  labelFld->coordinateType = PoLabelField::COORDINATE_IN_DOMAIN ;
  labelFld->set("appearance.font", "name Courier") ;
  
  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(group2Axis) ;
  root->addChild(labelFld) ;
  
  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Label field");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


