#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>
#include <GraphEditors.h>
#include <GraphAuditors.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;
   SoDialogViz::init();
   
   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(50., 5., 0) ;
   myDomain->max.setValue(100., 10., 1) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   SoSeparator *root = new SoSeparator ;

   PoLinearAxis *linXAxis1 = new PoLinearAxis ;
   linXAxis1->titleVisibility = PoLinearAxis::VISIBILITY_ON ;
   linXAxis1->titleString.setValue("X-Axis1") ;
   linXAxis1->start.setValue(50., 5., 0.) ;
   linXAxis1->end = 100. ;
   linXAxis1->tickSubDef = PoLinearAxis::NUM_SUB_TICK ;
   linXAxis1->tickNumOrPeriod = 1 ;

   PoLinearAxis *linXAxis2 = new PoLinearAxis ;
   linXAxis2->titleVisibility = PoLinearAxis::VISIBILITY_ON ;
   linXAxis2->titleString.setValue("X-Axis2") ;
   linXAxis2->start.setValue(50., 7., 0.) ;
   linXAxis2->end = 100. ;
   linXAxis2->marginStart = 0.1f;
   linXAxis2->gradStart = 30;
   linXAxis2->gradEnd = 5;
   linXAxis2->tickSubDef = PoLinearAxis::NUM_SUB_TICK ;
   linXAxis2->tickNumOrPeriod = 1 ;

   PoLinearAxis *linYAxis = new PoLinearAxis(SbVec3f(50.,5.,0.), 10., 
					     PoLinearAxis::YX, 0.) ;
   // Create axis editor
   SoRef<SoTopLevelDialog> editor = GraphEditors::createLinearAxisEditor();

   LinearGraphAuditor* myAuditor = new LinearGraphAuditor( linXAxis1 );

   editor->addAuditor(myAuditor);
   editor->setSynchronizable(false);
   editor->buildDialog( myWindow, FALSE );
   editor->show();

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;
   root->addChild(linXAxis1) ;
   root->addChild(linXAxis2) ;
   root->addChild(linYAxis) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Linear Axis");
   viewer->viewAll() ;

   viewer->show();
   editor->show();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  editor = NULL;
  delete myAuditor;

  root->unref();
  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


