//
// PoLinearValueLegend
//
////////////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoLinearValueLegend.h>

#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoNonLinearDataMapping2.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

#include <GraphAuditors.h>
#include <GraphEditors.h>

int  main(int, char **argv)
{
  float   values[5] = {0.0F, 0.00125F, 0.0025F, 0.0075F, 0.0100F} ;
  SbColor colors[5] = {SbColor(0.0,0.0,1.0), SbColor(0.0,1.0,1.0), SbColor(0.0,1.,0.), 
		       SbColor(1.0,1.0,0.0), SbColor(1.0,0.0,0.0)} ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();
  
  SoAnnotation *root = new SoAnnotation ;
  root->ref() ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  root->addChild(myTextAttr) ;

  PoNonLinearDataMapping2 *myDataMapping = new PoNonLinearDataMapping2 ;
  myDataMapping->value.setValues(0, 5, values) ;
  myDataMapping->color.setValues(0, 5, colors) ;
  myDataMapping->minThresholdEnabled = TRUE ;
  myDataMapping->maxThresholdEnabled = TRUE ;
  myDataMapping->minThreshold = -10e5 ;
  myDataMapping->minThresholdColor.setValue(0.5, 0.5, 0.5) ;
  myDataMapping->maxThreshold =  10e5 ;
  myDataMapping->maxThresholdColor.setValue(0.5, 0.5, 0.5) ;
  root->addChild(myDataMapping) ;

  PoLinearValueLegend *legend = new PoLinearValueLegend(SbVec2f(0.F,0.F), SbVec2f(0.3F, 1.0F)) ;
  legend->titleString.setValue("Pressure") ;
  legend->titleFontSize = 0.075F ;
  legend->titleVisibility = PoLinearValueLegend::VISIBILITY_ON ;
  legend->boxRatio = 2. ;
  legend->incrementType = PoLinearValueLegend::VERTICAL_INCREMENT ;
  legend->set("backgroundApp.material", "diffuseColor 0 0 0") ;
  legend->set("backgroundBorderApp.material", "diffuseColor 1 0 0") ;

  root->addChild(legend) ;

  // Create legend editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createLinearValueLegendEditor();

  LegendLinearValueAuditor* myAuditor = new LegendLinearValueAuditor( legend );

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();

  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Linear value legend");
  viewer->show();
  viewer->viewAll();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  root->unref();
  delete viewer;
  editor = NULL;
  delete myAuditor;

  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/
