//
// PoLogAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoLogAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>
#include <GraphEditors.h>
#include <GraphAuditors.h>

int  main(int, char **argv)
{
  static short decGradList[8] = {2,3,4,5,6,7,8,9} ;

   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;
   SoDialogViz::init();

   SoSeparator *root = new SoSeparator ;

   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue(0., 0., 0.) ;
   myDomain->max.setValue(3., 3., 3.) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   PoLogAxis *logAxisX = new PoLogAxis ;
   logAxisX->titleVisibility = PoLogAxis::VISIBILITY_ON ;
   logAxisX->titleString.setValue("X-Axis") ;
   logAxisX->tenPowerRep = PoLogAxis::TEN_POWER_POW10 ;
   logAxisX->decadeRep = PoLogAxis::DECADE_DIGIT ;
   logAxisX->gradPath = PoLogAxis::PATH_RIGHT ;
   logAxisX->gradPosition = PoLogAxis::GRAD_BELOW ;
   logAxisX->end = 3. ;
   logAxisX->titlePosition = PoLogAxis::TITLE_END ;
   logAxisX->set("bodyApp.material", "diffuseColor 1 0 0") ;

   PoLogAxis *logAxisY = 
     new PoLogAxis(SbVec3f(0.,0.,0.), 3., PoLogAxis::YX,
		   PoLogAxis::DECADE_LIST_NON_AUTO, (const unsigned short *)
		   decGradList, 8) ;
   
   // Create axis editor
   SoRef<SoTopLevelDialog> editor = GraphEditors::createLogAxisEditor();

   LogGraphAuditor* myAuditor = new LogGraphAuditor( logAxisX );

   editor->addAuditor(myAuditor);
   editor->setSynchronizable(false);
   editor->buildDialog( myWindow, FALSE );
   editor->show();

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;
   root->addChild(logAxisX) ;
   root->addChild(logAxisY) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Logarithmic Axis");
   
   viewer->show();
   viewer->viewAll();
   editor->show();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  editor = NULL;
  delete myAuditor;

  root->unref();
  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


