//
//  multiViewDemo
////////////////////////////////

#include <ctype.h>

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoText3.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoRotation.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoAnnoText3Property.h>
#include <Inventor/nodes/SoImage.h>
#include <Inventor/sensors/SoNodeSensor.h>

#include <Inventor/actions/SoWriteAction.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoLogAxis.h>
#include <MeshViz/graph/PoRectangle.h>
#include <MeshViz/graph/PoCurve.h>
#include <MeshViz/graph/PoItemLegend.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PbDomain.h>
#include <MeshViz/graph/PbMiscTextAttr.h>

#include <HardCopy/SoVectorizePSAction.h>

#include <Inventor/Gui/view/PoSceneView.h>

#include <Inventor/helpers/SbFileHelper.h>

#include <DialogViz/SoDialogVizAll.h>

#include <GraphEditors.h>
#include <GraphAuditors.h>

SbString dataFilePath = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/");

SbString FILE_NAME = SbFileHelper::expandString("$OIVHOME/examples/data/MeshViz/CURVE.DAT");
#define MAX_CURVES       10
#define MAX_CURVE_POINTS 1000
#define MAX_CURVE_NAME   80
#define MAX_STR_LEN      80

SoSeparator *root, *viewsToPrint, *sceneCurveView ;
SoSelection *sceneCurveViewSelection ;
SoSwitch    *zoomRectSwitch ;

Widget myWindow ;

SoRef<SoTopLevelDialog> axisEditor;
LinearGraphAuditor* myAuditor = NULL;

SbVec2f curvePts[MAX_CURVES][MAX_CURVE_POINTS] ;
char    *curvesName[MAX_CURVES] ;
char    societyLogoStr[MAX_STR_LEN] ;
char    curvesTitleStr[MAX_STR_LEN] ;
char    dateTitleStr[MAX_STR_LEN] ;
char    legendTitleStr[MAX_STR_LEN] ;
char    xAxisTitleStr[MAX_STR_LEN] ;
char    yAxisTitleStr[MAX_STR_LEN] ;
SbColor curvesColor[MAX_CURVES] ;
int     numCurvePoints[MAX_CURVES] ;
int     numCurves ;
float   xCurveMin, xCurveMax, yCurveMin, yCurveMax ;

PoRectangle *zoomRectangle ;

SoOrthographicCamera *cameraZoomView ;

/*---------------------------------------------------------------------------*/

static void
sceneCurveViewSelectionCB(void *, SoPath *path) 
{
  if(path->getTail()->isOfType(PoGroup2Axis::getClassTypeId())) {
    SoNodeKitPath *nodeKitPath = (SoNodeKitPath *) path ;

     if(!axisEditor.ptr()) {
       // Create axis editor
        axisEditor = GraphEditors::createLinearAxisEditor();

       myAuditor = new LinearGraphAuditor( (PoLinearAxis*)nodeKitPath->getTail() );

       axisEditor->addAuditor(myAuditor);
       axisEditor->setSynchronizable(false);
       axisEditor->buildDialog( myWindow, FALSE );
     }

     ((LinearGraphAuditor*) axisEditor->getAuditors().begin()->auditor )->setAxis((PoLinearAxis*)nodeKitPath->getTail());
     axisEditor->show() ;
  }
}/*---------------------------------------------------------------------------*/

static void
eliminateComments(const char *strWithComment, char *strWithoutComment)
{
  int i=0, j=0;
  while(strWithComment[i] != '\0' && strWithComment[i] != '#')
    strWithoutComment[j++] = strWithComment[i++] ;
  
  while(!isalnum(strWithoutComment[j-1])) j--;
  strWithoutComment[j] = '\0' ;

}/*---------------------------------------------------------------------------*/
static void 
cameraZoomSensorCB(void *, SoSensor *sensor)
{
  SoOrthographicCamera *camera = (SoOrthographicCamera*) ((SoNodeSensor*)sensor)->getAttachedNode() ;
  float camHeightDiv2 = camera->height.getValue() / 2.0f ;
  zoomRectangle->p.setValue(camera->position.getValue()[0] - camHeightDiv2,
			    camera->position.getValue()[1] - camHeightDiv2) ;

  zoomRectangle->q.setValue(camera->position.getValue()[0] + camHeightDiv2,
			    camera->position.getValue()[1] + camHeightDiv2) ;

}/*---------------------------------------------------------------------------*/

static void 
readDataFile(const char *fileName)
{
  FILE *filePtr ;
  char  string[200] ;
  float r, g, b ;
  int i;
  SbString SbFileName= fileName;
  SbString OpenedFile = SbFileName;
  filePtr = SbFileHelper::open(OpenedFile , "r" ) ;

  if (filePtr == NULL ) {
    printf ("file %s not found\n", fileName);
    exit(1);
  }
  xCurveMax = yCurveMax = -1E30F ;
  xCurveMin = yCurveMin = 1E30F ;

  fgets(string, 200, filePtr) ; eliminateComments(string, societyLogoStr) ;
  fgets(string, 200, filePtr) ; eliminateComments(string, curvesTitleStr) ;
  fgets(string, 200, filePtr) ; eliminateComments(string, dateTitleStr) ;
  fgets(string, 200, filePtr) ; eliminateComments(string, legendTitleStr) ;
  fgets(string, 200, filePtr) ; eliminateComments(string, xAxisTitleStr) ;
  fgets(string, 200, filePtr) ; eliminateComments(string, yAxisTitleStr) ;
  fgets(string, 200, filePtr) ; sscanf(string, "%d", &numCurves) ; 
  for(i=0; i < numCurves; i++) {
    curvesName[i] = new char [MAX_CURVE_NAME] ;
    fgets(string, 200, filePtr) ; eliminateComments(string, curvesName[i]) ;
    fgets(string, 200, filePtr) ; sscanf(string, "%f%f%f", &r, &g, &b) ; 
    curvesColor[i].setValue(r, g, b) ;
    fgets(string, 200, filePtr) ; sscanf(string, "%d", &numCurvePoints[i]) ; 

    for(int j = 0; j < numCurvePoints[i]; j++) {      
      fgets(string, 200, filePtr) ; sscanf(string, "%f%f", &curvePts[i][j][0], &curvePts[i][j][1]) ;
      if(curvePts[i][j][0] > xCurveMax) xCurveMax = curvePts[i][j][0] ;
      if(curvePts[i][j][0] < xCurveMin) xCurveMin = curvePts[i][j][0] ;
      if(curvePts[i][j][1] > yCurveMax) yCurveMax = curvePts[i][j][1] ;
      if(curvePts[i][j][1] < yCurveMin) yCurveMin = curvePts[i][j][1] ;
    }
  }
  fclose(filePtr) ;

}/*---------------------------------------------------------------------------*/


class QuitAuditor : public SoDialogPushButtonAuditor
{
  public:
  void dialogPushButton(SoDialogPushButton* /*cpt*/)
  {
    exit( 0 );
  }
};

class WriteIVAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton(SoDialogPushButton* /*cpt*/)
  {
    SoWriteAction myAction;

    myAction.getOutput()->openFile("multiViewDemo.iv");
    myAction.getOutput()->setBinary(FALSE);
    myAction.apply(root);
    myAction.getOutput()->closeFile();
  }
};

class WritePSAuditor : public SoDialogPushButtonAuditor
{
public:
  void dialogPushButton(SoDialogPushButton* /*cpt*/)
  {
    SoVectorizePSAction vectPSAction ;
    vectPSAction.setDrawingDimensions(277, 190) ;
    vectPSAction.setOrientation(SoVectorizeAction::LANDSCAPE) ;
    vectPSAction.getPSVectorOutput()->openFile("multiViewDemo.ps") ;
    int zoomSwitchValue = zoomRectSwitch->whichChild.getValue() ;
    zoomRectSwitch->whichChild.setValue(SO_SWITCH_NONE) ;
    vectPSAction.apply(viewsToPrint) ;
    zoomRectSwitch->whichChild.setValue(zoomSwitchValue) ;
    vectPSAction.getPSVectorOutput()->closeFile() ;
  }
};

class CurveTypeAuditor : public SoDialogChoiceAuditor
{
public:
  void dialogChoice( SoDialogChoice* cpt )
  {
    PoCurve::CurveRep curveRep = PoCurve::CURVE_NONE;
    switch ( cpt->selectedItem.getValue() )
    {
    case 0:
      curveRep = PoCurve::CURVE_SMOOTH;
      break;

    case 1:
      curveRep = PoCurve::CURVE_POLYLINE;
      break;

    case 2:
      curveRep = PoCurve::CURVE_STAIRS_X;
      break;
    }
    for ( int i = 2; i < sceneCurveView->getNumChildren(); i += 2 )
      ( (PoCurve*) sceneCurveView->getChild( i ) )->curveRep = curveRep;
  }
};

static SoTopLevelDialog*
buildDialog(Widget rootWidget) 
{
  SoTopLevelDialog *dialog = new SoTopLevelDialog;

  static const char *curveType[3] = {
    "SMOOTH",
    "POLYLINE",
    "STAIRS"
  } ;
  SoDialogComboBox* curveTypeCombo = new SoDialogComboBox();
  curveTypeCombo->label.setValue( "Curve type:" );
  curveTypeCombo->items.setValues( 0, 3, curveType );
  curveTypeCombo->addAuditor( new CurveTypeAuditor() );
  dialog->addChild( curveTypeCombo );

  SoDialogPushButton* writePS = new SoDialogPushButton();
  writePS->label = "PS file :";
  writePS->buttonLabel.setValue( "Write multiViewDemo.ps" );
  writePS->addAuditor( new WritePSAuditor() );
  dialog->addChild( writePS );

  SoDialogPushButton* writeIV = new SoDialogPushButton();
  writeIV->label = "OIV file :";
  writeIV->buttonLabel.setValue( "Write multiViewDemo.iv" );
  writeIV->addAuditor( new WriteIVAuditor() );
  dialog->addChild( writeIV );

  SoDialogPushButton* Quit = new SoDialogPushButton();
  Quit->buttonLabel.setValue( "Quit" );
  Quit->addAuditor( new QuitAuditor() );
  dialog->addChild( Quit );

  dialog->buildDialog( rootWidget );

  return dialog ;
}/*---------------------------------------------------------------------------*/

static
SbBool viewerEventCB(SoXtViewer *viewer, XAnyEvent* /*anyEvent*/) 
{
  if(viewer->getCamera() == cameraZoomView) 
    zoomRectSwitch->whichChild.setValue(SO_SWITCH_ALL) ;
  else
    zoomRectSwitch->whichChild.setValue(SO_SWITCH_NONE) ;
  return FALSE ;

}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int main (int, char **argv)
{
   int i;
   // Initialize Inventor and Xt
   myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   readDataFile(FILE_NAME.toLatin1()) ;
   PbDomain domain(xCurveMin, yCurveMin, xCurveMax * 0.8f, yCurveMax) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;
   SoDialogViz::init();

   SoBaseKit::setSearchingChildren(TRUE) ;

   PbMiscTextAttr textAttr ;
#ifdef _WIN32
   textAttr.setFontName("Arial") ;
#else
   textAttr.setFontName("Courier") ;
#endif

   root = new SoSeparator ;

   SoAnnoText3Property *annoText3Property = new SoAnnoText3Property ;
   annoText3Property->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER ;

   //***************************** Curve view *************************
   PoGroup2Axis *g2Axis = new 
     PoGroup2Axis(SbVec2f(xCurveMin, yCurveMin), SbVec2f(xCurveMax, yCurveMax), PoGroup2Axis::LINEAR, 
		  PoGroup2Axis::LINEAR, xAxisTitleStr, yAxisTitleStr) ;
   g2Axis->setDomain(&domain) ;

   PoLinearAxis *xAxis = SO_GET_PART(g2Axis, "xAxis", PoLinearAxis) ;
   PoLinearAxis *yAxis = SO_GET_PART(g2Axis, "yAxis", PoLinearAxis) ;

   xAxis->setMiscTextAttr(&textAttr) ;
   xAxis->gridVisibility = PoAxis::VISIBILITY_ON ;
   xAxis->set("mainGradGridApp.drawStyle", "linePattern 0xF0F0") ;

   yAxis->setMiscTextAttr(&textAttr) ;
   yAxis->gridVisibility = PoAxis::VISIBILITY_ON ;
   yAxis->set("mainGradGridApp.drawStyle", "linePattern 0xF0F0") ;

   sceneCurveViewSelection = new SoSelection ;
   sceneCurveViewSelection->addSelectionCallback(sceneCurveViewSelectionCB) ;
   SoPickStyle *pickStyle = new SoPickStyle ;
   pickStyle->style = SoPickStyle::BOUNDING_BOX ;
   sceneCurveViewSelection->addChild(pickStyle) ;
   
   sceneCurveView = new SoSeparator ;
   sceneCurveViewSelection->addChild(sceneCurveView) ;
   zoomRectangle = new PoRectangle ;
   SoDrawStyle *zoomRectStyle = new SoDrawStyle ;
   zoomRectStyle->style = SoDrawStyle::LINES ;
   SoMaterial *zoomRectMaterial = new SoMaterial ;
   zoomRectMaterial->diffuseColor.setValue(1., 0., 0.) ;
   zoomRectSwitch = new SoSwitch ;
   zoomRectSwitch->addChild(zoomRectMaterial) ;
   zoomRectSwitch->addChild(zoomRectStyle) ;
   zoomRectSwitch->addChild(zoomRectangle) ;
   sceneCurveViewSelection->addChild(zoomRectSwitch) ;
   
   sceneCurveView->addChild(g2Axis) ;

   for(i=0; i < numCurves; i++) {
     PoCurve *curve = new PoCurve(numCurvePoints[i], &curvePts[i][0], PoCurve::CURVE_SMOOTH) ;
     curve->setDomain(&domain)  ;
     SoMaterial *curveMaterial = new SoMaterial ;
     curveMaterial->diffuseColor.setValue(curvesColor[i]) ;
     curve->setPart("appearance.material", curveMaterial) ;
     sceneCurveView->addChild(curveMaterial) ;
     sceneCurveView->addChild(curve) ; 
   }

   PoSceneView *curveView = new PoSceneView ;
   curveView->isBorderVisible = TRUE ;
   curveView->sensitiveOnEvents(TRUE) ;
   curveView->viewportOrigin.setValue(0.02F, 0.F) ;
   curveView->viewportSize.setValue(0.98F, 0.9F) ;
   curveView->setPart("scene", sceneCurveViewSelection) ;
   SoOrthographicCamera *cameraCurve = new SoOrthographicCamera ;
   curveView->setPart("cameraKit.camera", cameraCurve) ;

   //**************************** Society logo view *******************
   SoSeparator *sceneSocietyLogoView = new SoSeparator ;

   SoImage *societyLogo = new SoImage ;
   SbString logoFilename(dataFilePath) ; 
   logoFilename += societyLogoStr ;
   societyLogo->filename = logoFilename  ;
   societyLogo->horAlignment = SoImage::CENTER ;
   societyLogo->vertAlignment = SoImage::HALF ;
   
   // Fixes the requested image size
   societyLogo->width = 120 ;
   societyLogo->height = 48 ;

   sceneSocietyLogoView->addChild(societyLogo) ;
   
   PoSceneView *societyLogoView = new PoSceneView ;
   societyLogoView->isBorderVisible = TRUE ;
   societyLogoView->viewportOrigin.setValue(0.02F, 0.9F) ;
   societyLogoView->viewportSize.setValue(0.18F, 0.1F) ;
   societyLogoView->setPart("scene", sceneSocietyLogoView) ;
   SoOrthographicCamera *cameraSocietyLogo = new SoOrthographicCamera ;
   societyLogoView->setPart("cameraKit.camera", cameraSocietyLogo) ;
#ifdef _WIN32
   // HACK for some openGL drivers which clip anormally lines
   societyLogoView->set("borderApp.drawStyle", "lineWidth 1.5") ;
#endif


   //*************************** Curve title view ***********************
   SoSeparator *sceneCurveTitleView = new SoSeparator ;
   SoText2 *curveTitle = new SoText2 ;
   curveTitle->string = curvesTitleStr ;
   curveTitle->justification = SoText2::CENTER ;
   SoFont *fontCurveTitle = new SoFont ;
   fontCurveTitle->size.setValue(20) ;
#ifdef _WIN32
   fontCurveTitle->name = "Arial" ;
#else
   fontCurveTitle->name = "Times-Italic" ;	
#endif
   sceneCurveTitleView->addChild(fontCurveTitle) ;
   sceneCurveTitleView->addChild(curveTitle) ;

   PoSceneView *curveTitleView = new PoSceneView ;
   curveTitleView->isBorderVisible = TRUE ;
   curveTitleView->viewportOrigin.setValue(0.2F, 0.9F) ;
   curveTitleView->viewportSize.setValue(0.6F, 0.1F) ;
   curveTitleView->setPart("scene", sceneCurveTitleView) ;
   SoOrthographicCamera *cameraCurveTitle = new SoOrthographicCamera ;
   curveTitleView->setPart("cameraKit.camera", cameraCurveTitle) ;
#ifdef _WIN32
   // HACK for some openGL drivers which clip anormally lines
   curveTitleView->set("borderApp.drawStyle", "lineWidth 1.5") ;
#endif



   //************************** Date title view ************************
   SoSeparator *sceneDateTitleView = new SoSeparator ;
   SoText2 *dateTitle = new SoText2 ;
   dateTitle->string = dateTitleStr ;
   dateTitle->justification = SoText2::CENTER ;
   SoFont *fontDateTitle = new SoFont ;
   fontDateTitle->size.setValue(14) ;
#ifdef _WIN32
   fontDateTitle->name = "Arial" ;
#else
   fontDateTitle->name = "Times-Roman" ;
#endif
   sceneDateTitleView->addChild(fontDateTitle) ;
   sceneDateTitleView->addChild(dateTitle) ;

   PoSceneView *dateTitleView = new PoSceneView ;
   dateTitleView->isBorderVisible = TRUE ;
   dateTitleView->viewportOrigin.setValue(0.8F, 0.9F) ;
   dateTitleView->viewportSize.setValue(0.2F, 0.1F) ;
   dateTitleView->setPart("scene", sceneDateTitleView) ;
   SoOrthographicCamera *cameraDateTitle = new SoOrthographicCamera ;
   dateTitleView->setPart("cameraKit.camera", cameraDateTitle) ;
#ifdef _WIN32
   // HACK for some openGL drivers which clip anormally lines
   dateTitleView->set("borderApp.drawStyle", "lineWidth 1.5") ;
#endif



   //************************** Legend view ************************
   SoAnnotation *sceneLegendView = new SoAnnotation ;
   PoItemLegend *legend = new 
     PoItemLegend(SbVec2f(0.,0.), SbVec2f(1.0, 1.0), numCurves, (const char**)curvesName, curvesColor) ;
   legend->titleString.setValue(legendTitleStr) ;
   legend->titleFontSize = 0.15F ;
   legend->titleVisibility = PoItemLegend::VISIBILITY_ON ;
   legend->setMiscTextAttr(&textAttr) ;
   legend->boxRatio = 2. ;
   legend->set("backgroundApp.material", "diffuseColor 0 0 0") ;
   legend->set("backgroundBorderApp.material", "diffuseColor 1 0 0") ;

   sceneLegendView->addChild(legend) ;

   PoSceneView *legendView = new PoSceneView ;
   legendView->viewportOrigin.setValue(0.8F, 0.6F) ;
   legendView->viewportSize.setValue(0.2F, 0.3F) ;
   legendView->setPart("scene", sceneLegendView) ;
   SoOrthographicCamera *cameraLegend = new SoOrthographicCamera ;
   legendView->setPart("cameraKit.camera", cameraLegend) ;

   //************************** Zoom view *****************************
   SoAnnotation *zoomViewAnnot = new SoAnnotation ;
   PoSceneView *zoomView = new PoSceneView ;
   zoomViewAnnot->addChild(zoomView) ;
   zoomView->sensitiveOnEvents(TRUE) ;
   zoomView->isBorderVisible = TRUE ;
   zoomView->viewportOrigin.setValue(0.8F, 0.0F) ;
   zoomView->viewportSize.setValue(0.2F, 0.3F) ;
   zoomView->setPart("scene", sceneCurveView) ;
   cameraZoomView = new SoOrthographicCamera ;
   zoomView->setPart("cameraKit.camera", cameraZoomView) ;
   SoNodeSensor *cameraZoomSensor = new SoNodeSensor(cameraZoomSensorCB, NULL) ;
   cameraZoomSensor->attach(cameraZoomView) ;
#ifdef _WIN32
   // HACK for some openGL drivers which clip anormally lines
   zoomView->set("borderApp.drawStyle", "lineWidth 1.5") ;
#endif


   //************************** Print name view *****************************
   SoSeparator *scenePrintNameView = new SoSeparator ;
   SoLightModel *printNameLightModel = new SoLightModel ;
   printNameLightModel->model = SoLightModel::BASE_COLOR ;
   SoFont *fontPrintName = new SoFont ;
#ifdef _WIN32
   fontPrintName->name = "Arial" ;
#else
   fontPrintName->name = "Times-Roman" ;
#endif
   SoText3 *printName = new SoText3 ;
   printName->string = "Printed with MeshViz" ;
   SoDrawStyle *stylePrintName = new SoDrawStyle ;
   stylePrintName->style = SoDrawStyle::LINES ;
   SoRotation *printNameRotation = new SoRotation ;
   printNameRotation->rotation.setValue(SbVec3f(0.F, 0.F, 1.F), float(PPI/2.)) ;
   scenePrintNameView->addChild(printNameLightModel) ;
   scenePrintNameView->addChild(stylePrintName) ;
   scenePrintNameView->addChild(printNameRotation) ;
   scenePrintNameView->addChild(fontPrintName) ;
   scenePrintNameView->addChild(printName) ;
   
   PoSceneView *printNameView = new PoSceneView ;
   printNameView->viewportOrigin.setValue(0.0, 0.0) ;
   printNameView->viewportSize.setValue(0.02F, 1.) ;
   printNameView->setPart("scene", scenePrintNameView) ;
   SoOrthographicCamera *cameraPrintNameView = new SoOrthographicCamera ;
   printNameView->setPart("cameraKit.camera", cameraPrintNameView) ;

   // View all for all cameras
   SbViewportRegion vp;
   vp.setWindowSize(730, 500) ;
   vp.setViewport(0.3F, 0.3F, 0.5F, 0.5F) ;
   cameraSocietyLogo->viewAll(sceneSocietyLogoView, vp) ;
   cameraCurveTitle->viewAll(sceneCurveTitleView, SbViewportRegion(100, 100)) ;
   cameraDateTitle->viewAll(sceneDateTitleView, SbViewportRegion(100, 100)) ;
   cameraLegend->viewAll(sceneLegendView, SbViewportRegion(100, 100)) ;
   
   cameraPrintNameView->position.setValue(-3, 222, 57) ;
   cameraPrintNameView->nearDistance.setValue(56.95F) ;
   cameraPrintNameView->farDistance.setValue(58) ;
   cameraPrintNameView->height.setValue(13) ;

   cameraZoomView->position.setValue(3885, 74, 3170) ;
   cameraZoomView->nearDistance.setValue(3167) ;
   cameraZoomView->farDistance.setValue(3175) ;
   cameraZoomView->height.setValue(487) ;

   cameraCurve->position.setValue(3760, 1650, 3150) ;
   cameraCurve->nearDistance.setValue(3140) ;
   cameraCurve->farDistance.setValue(3145) ;
   cameraCurve->height.setValue(4580) ;

   SoMaterial *material = new SoMaterial ;
   material->diffuseColor.setValue(1., 1., 1.) ;

   viewsToPrint = new SoSeparator ;
   viewsToPrint->addChild(annoText3Property) ;
   viewsToPrint->addChild(material) ;
   viewsToPrint->addChild(curveView) ;
   viewsToPrint->addChild(societyLogoView) ;
   viewsToPrint->addChild(curveTitleView) ;
   viewsToPrint->addChild(dateTitleView) ;
   viewsToPrint->addChild(legendView) ;
   viewsToPrint->addChild(printNameView) ;

   root->ref() ;
   root->addChild(viewsToPrint) ;
   root->addChild(material) ;
   root->addChild(zoomViewAnnot) ;

   SoTopLevelDialog* dialog = buildDialog( myWindow );

   SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
   viewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST) ;
   viewer->setEventCallback((SoXtRenderAreaEventCB*)viewerEventCB, viewer) ;
   viewer->setSceneGraph(root);
   viewer->setCamera(cameraCurve) ;
   viewer->setSize(SbVec2s(730, 500)) ;
   viewer->setTitle("Multi View Demo");
   viewer->show();

   dialog->show() ;

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  axisEditor = NULL;
  delete myAuditor;
  root->unref();

  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/
