//
// PoLinearAxis
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoTransformSeparator.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoRectangle.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;

   PoDomain *myDomain = new PoDomain ;
   myDomain->min.setValue(50.F ,  0.F, 0.F) ;
   myDomain->max.setValue(100.F, 0.1F, 1.F) ;

   PoDomain *myDomain2 = new PoDomain ;
   myDomain2->min.setValue(50. ,  5., 0.) ;
   myDomain2->max.setValue(100., 10,  1.) ;

   PoDomain *myDomain3 = new PoDomain ;
   myDomain3->min.setValue(50. ,  -3., 0.) ;
   myDomain3->max.setValue(100.,  -2,  1.) ;

   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   PoLinearAxis *linAxisX = new PoLinearAxis ;
   linAxisX->titleVisibility = PoLinearAxis::VISIBILITY_ON ;
   linAxisX->titleString.setValue("X-Axis") ;
   linAxisX->start.setValue(50., 5., 0.) ;
   linAxisX->end = 100. ;

   PoLinearAxis *linAxisY = new PoLinearAxis(SbVec3f(50.,5.,0.), 10., PoLinearAxis::YX, 0.) ;
   PoLinearAxis *linAxis2Y = new PoLinearAxis(SbVec3f(40.,0.,0.), 0.1F, PoLinearAxis::YX, 0.) ;
   PoLinearAxis *linAxis3Y = new PoLinearAxis(SbVec3f(30.,-3.,0.), -2, PoLinearAxis::YX, 0.) ;

   PoRectangle *rect = new PoRectangle(SbVec2f(60, 6), SbVec2f(70, 7.5)) ;
   PoRectangle *rect2 = new PoRectangle(SbVec2f(90, 0.05F), SbVec2f(95, 0.08F)) ;
   PoRectangle *rect3 = new PoRectangle(SbVec2f(65, -2.4F), SbVec2f(70, -2.1F)) ;

   SoTranslation *translate = new SoTranslation ;
   translate->translation.setValue(80., 7., 0.) ;
   SoCube *cube = new SoCube ;
   cube->width = 10 ;
   cube->height = 1 ;
   cube->depth = 0.02F ;

   SoTranslation *translate2 = new SoTranslation ;
   translate2->translation.setValue(0., 50., 0.) ;

   SoTransformSeparator *transSep = new SoTransformSeparator ;
   transSep->addChild(translate2) ;
   transSep->addChild(linAxis2Y) ;
   transSep->addChild(rect2) ;
   linAxis2Y->set("bodyApp.material", "diffuseColor 1 0 0") ;
   rect2->set("appearance.material", "diffuseColor 1 0 0") ;

   SoTranslation *translate3 = new SoTranslation ;
   translate3->translation.setValue(0., 200., 0.) ;

   SoTransformSeparator *transSep2 = new SoTransformSeparator ;
   transSep2->addChild(translate3) ;
   transSep2->addChild(linAxis3Y) ;
   transSep2->addChild(rect3) ;
   linAxis3Y->set("bodyApp.material", "diffuseColor 0 1 0") ;
   rect3->set("appearance.material", "diffuseColor 0 1 0") ;

   root->ref() ;
   root->addChild(myTextAttr) ;
   root->addChild(myDomain2) ;
   root->addChild(rect) ;
   root->addChild(linAxisX) ;
   root->addChild(linAxisY) ;
   root->addChild(myDomain) ;
   root->addChild(transSep) ;
   root->addChild(myDomain3) ;
   root->addChild(transSep2) ;
   root->addChild(myDomain2->getTransform()) ;
   root->addChild(translate) ;
   root->addChild(cube) ;

   SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Multiple Axis");
   viewer->show();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


