//
// PoMultipleHistogram
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>

#include <MeshViz/graph/PoMultipleHistogram.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NUM_ROW 8
#define NUM_COL 3

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  static const char *month[NUM_ROW] = {
    "JAN","FEB","MAR","APR","MAY","JUNE","JULY","AUG"
  } ;
  static const char *facture[NUM_COL] = {
    "EAU","GAZ","EDF"
  } ;
  static float value[NUM_ROW][NUM_COL] = {
    {5.0F, 4.1F, 3.3F},
    {7.0F, 2.8F, 1.3F},
    {4.0F, 2.0F, 3.0F},
    {3.0F, 2.0F, 1.2F},
    {6.0F, 3.1F, 1.5F},
    {5.0F, 3.2F, 2.5F},
    {4.0F, 2.2F, 5.8F},
    {3.0F, 5.1F, 1.9F}
  } ;
  SbColor colors[NUM_COL] = {
    SbColor(0.F, 0.F, 1.F), SbColor(1.F, 0.F, 0.F), SbColor(0.F, 0.7F, 0.F)
  } ;

  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  SoAnnotation *root = new SoAnnotation ;

  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(0., 0.,0) ;
  myDomain->max.setValue(10., 10.,1) ;
  
  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";

  PoMultipleHistogram *histog = 
    new PoMultipleHistogram(SbVec2f(-3., 0.), 13., PoMultipleHistogram::X, 
			    NUM_ROW, NUM_COL, (const float*)value, month, 
			    facture) ;

  histog->set("valueTextApp.material", "diffuseColor 1 1 1") ;
  histog->set("nameTextApp.material", "diffuseColor 1 1 1") ;
  histog->set("sumTextApp.material", "diffuseColor 0.8 0 0") ;
  histog->valuePath = PoMultipleHistogram::PATH_UP ;
  histog->color.setValues(0, NUM_COL, colors) ;
  histog->valueFontSize = 0.05F ;
  histog->nameFontSize = 0.07F ;
  histog->sumFontSize = 0.05F ;

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(histog) ;

  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Multiple Histogram");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


