//
// PoParallelogram
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoParallelogram.h>


/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoParallelogram *paral = new 
     PoParallelogram(SbVec2f(0.0, 0.0), SbVec2f(3.0, 0.5), 
		     SbVec2f(4.5, 2.5)) ;

   root->ref() ;
   root->addChild(paral) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Parallelogram");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


