//
// PoParallelogram3
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoParallelogram3.h>

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int main(int, char **argv)

{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
    PoParallelogram3 *paral = new 
      PoParallelogram3(SbVec3f(0.0, 0.0, 0.0), SbVec3f(3.0, 0.0, 0.0), 
		       SbVec3f(1.0, 2.5, -5)) ;

   root->ref() ;
   root->addChild(paral) ;

   SoXtExaminerViewer *viewer = 
     new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Parallelogram 3");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


