//
// PoPieChart2D
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSelection.h>

#include <MeshViz/graph/PoPieChart2D.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoNumericDisplayFormat.h>

#define NUM_SLICES      19
#define NUM_COLORS      9
#define TRANSLATE_VALUE 0.75

PoPieChart2D *pieChart2D ;

/*---------------------------------------------------------------------------*/

void selectionPathCB(void *, SoPath *path) 
{  
  int slicePicked ;
  if(pieChart2D->getPickedSliceNumber(path, slicePicked)) {
    float sliceTranslateValue = pieChart2D->getSliceToTranslate(slicePicked) ;
    if(sliceTranslateValue <= 0) 
      pieChart2D->setSliceToTranslate(slicePicked, TRANSLATE_VALUE) ;
    else
      pieChart2D->setSliceToTranslate(slicePicked, 0.) ;
  }
}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  static const char *sliceTexts[NUM_SLICES] = {
    "Austria", "Canada", "C.I.S", "Czechoslovakia", "Finland",
    "France", "Germany", "Italy", "Japan", "Luxemburg",
    "Netherland", "New Zealand", "North Korea", "Norway",
    "South Korea", "Spain", "Sweden", "Switzerland",
    "United States"
  } ;
  static float sliceValues[NUM_SLICES] = {
    6, 2, 9, 0, 3, 3, 10, 4, 1, 0, 1, 0, 0, 9, 2, 1, 1, 1, 5
  } ;
  
  static SbColor sliceColors[NUM_COLORS] = {
    SbColor(0.4F, 1.0F, 1.0F), SbColor(0.2F, 0.1F, 1.0F), 
    SbColor(1.0F, 0.1F, 1.0F), SbColor(1.F, 0.6F, 0.5F), 
    SbColor(0.7F, 0.F, 0.4F), SbColor(0.8F, 0.2F, 0.2F),
    SbColor(0.1F, 1.0F, 0.5F), SbColor(0.1F, 0.8F, 0.1F), 
    SbColor(0.F, 0.6F, 0.F)
  } ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  
  PoDomain *myDomain = new PoDomain ;
  myDomain->min.setValue( 0., 0. , 0) ;
  myDomain->max.setValue(10., 10., 0) ;

  PoNumericDisplayFormat *myFormat = new PoNumericDisplayFormat ;
  myFormat->formatType = PoNumericDisplayFormat::INTEGER_FORMAT ;
  
  SoSelection *root = new SoSelection ;
  root->addSelectionCallback(selectionPathCB) ;
  
  pieChart2D = new PoPieChart2D(SbVec2f(5.0, 5.0), 2.5, NUM_SLICES, (const char**)sliceTexts, 
				sliceValues, NUM_COLORS, sliceColors) ;
  pieChart2D->sliceGroupMinValue.setValue(3) ;
  pieChart2D->sliceGroupFlagMin = PoPieChart::ABSOLUTE ;
  pieChart2D->sliceToTranslateNumber.set1Value(0, 4) ;
  pieChart2D->sliceToTranslateValue.set1Value(0, TRANSLATE_VALUE) ;
  pieChart2D->set("sliceBorderApp.drawStyle", "lineWidth 2") ;
  
  root->ref() ;
  root->addChild(myTextAttr) ;
  root->addChild(myDomain) ;
  root->addChild(myFormat) ;  
  root->addChild(pieChart2D) ;
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Pie Chart 2D");
  viewer->viewAll() ;

  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


