//
// PoPieChart3D
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/nodes/SoRotationXYZ.h>

#include <MeshViz/graph/PoPieChart3D.h>

#include <Inventor/nodes/SoAnnoText3Property.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoNumericDisplayFormat.h>

#define NUM_SLICES      19
#define NUM_COLORS      9
#define TRANSLATE_VALUE 0.75F
#define PIDIV4          0.785F

PoPieChart3D *pieChart3D ;

/*---------------------------------------------------------------------------*/

void selectionPathCB(void *, SoPath *path) 
{  
  int slicePicked ;
  if(pieChart3D->getPickedSliceNumber(path, slicePicked)) {
    float sliceTranslateValue = pieChart3D->getSliceToTranslate(slicePicked) ;
    if(sliceTranslateValue <= 0) 
      pieChart3D->setSliceToTranslate(slicePicked, TRANSLATE_VALUE) ;
    else
      pieChart3D->setSliceToTranslate(slicePicked, 0.) ;
  }
}/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  static const char *sliceTexts[NUM_SLICES] = {
    "Austria", "Canada", "C.I.S", "Czechoslovakia", "Finland",
    "France", "Germany", "Italy", "Japan", "Luxemburg",
    "Netherland", "New Zealand", "North Korea", "Norway",
    "South Korea", "Spain", "Sweden", "Switzerland",
    "United States"
  } ;
  static float sliceValues[NUM_SLICES] = {
    6, 2, 9, 0, 3, 3, 10, 4, 1, 0, 1, 0, 0, 9, 2, 1, 1, 1, 5
  } ;

  static SbColor sliceColors[NUM_COLORS] = {
    SbColor(0.4F, 1.0F, 1.0F), SbColor(0.2F, 0.1F, 1.0F), 
    SbColor(1.0F, 0.1F, 1.0F), SbColor(1.F, 0.6F, 0.5F), 
    SbColor(0.7F, 0.F, 0.4F), SbColor(0.8F, 0.2F, 0.2F),
    SbColor(0.1F, 1.0F, 0.5F), SbColor(0.1F, 0.8F, 0.1F), 
    SbColor(0.F, 0.6F, 0.F)
  } ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize the new nodes class
  PoMeshViz::init() ;
   
  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";

  PoDomain *myDomain = new PoDomain ;
  myDomain->min.setValue( 0.,  0.,  0.) ;
  myDomain->max.setValue(10., 10., 10.) ;

  PoNumericDisplayFormat *myFormat = new PoNumericDisplayFormat ;
  myFormat->formatType = PoNumericDisplayFormat::INTEGER_FORMAT ;

  SoAnnoText3Property *textProp = new SoAnnoText3Property ;
  textProp->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER ;
  textProp->fontSizeHint = SoAnnoText3Property::ANNOTATION ;
  
  SoSelection *root = new SoSelection ;
  root->addSelectionCallback(selectionPathCB) ;
  
  SoRotationXYZ *rotation = new SoRotationXYZ ;
  rotation->axis = SoRotationXYZ::X ;
  rotation->angle.setValue(-PIDIV4) ;

  pieChart3D = new PoPieChart3D(SbVec3f(5.0, 5.0, 3.0), 4.0, 2.5, NUM_SLICES, 
				sliceTexts, sliceValues, NUM_COLORS, sliceColors) ;
  pieChart3D->sliceGroupMinValue.setValue(3) ;
  pieChart3D->sliceGroupFlagMin = PoPieChart::ABSOLUTE ;
  pieChart3D->sliceToTranslateNumber.set1Value(0, 4) ;
  pieChart3D->sliceToTranslateValue.set1Value(0, TRANSLATE_VALUE) ;
  pieChart3D->extAnnotTextFontSize.setValue(0.04F) ;
  pieChart3D->set("sliceBorderApp.drawStyle", "lineWidth 2") ;
  pieChart3D->set("extAnnotBoxBorderApp.drawStyle", "style INVISIBLE") ;
  pieChart3D->set("extAnnotBoxApp.drawStyle", "style INVISIBLE") ;

  root->ref() ;
  root->addChild(myTextAttr) ;
  root->addChild(myDomain) ;
  root->addChild(myFormat) ;
  root->addChild(textProp) ;
  root->addChild(rotation) ;
  root->addChild(pieChart3D) ;
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Pie Chart 3D");
  viewer->viewAll() ;

  viewer->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


