//
// PoPieChartRep
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoAnnoText3Property.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoRotationXYZ.h>

#include <MeshViz/graph/PoPieChartRep.h>

#include <MeshViz/nodes/PoIrregularMesh1D.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoBevelEdge.h>
#include <MeshViz/nodes/PoLabelHints.h>

#define NP               6
#define NP_TRANSLATE     3
#define TRANSLATE_RADIUS 0.2f

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)

{
  static SbString sliceNames[NP]={"Post-Processing", "Oil&Gaz", "Aerospace", 
				  "Chemistry", "CAO", "Meterology"} ;
  static float    sliceValues[NP] = {350, 150, 160, 200, 100, 40} ;
  static SbColor  sliceDiffColors[NP] = { SbColor(0.2f, 0.2f, 0.6f), SbColor(0.2f, 0.6f, 0.6f), 
					  SbColor(0.6f, 0.6f, 0.3f), SbColor(0.6f, 0.0f, 0.f), 
					  SbColor(0.6f, 0.3f, 0.3f), SbColor(0.6f, 0.2f, 0.2f)} ;

  static SbColor  sliceSpecColors[NP] = { SbColor(0.2f, 0.2f, 0.8f), SbColor(0.5f, 0.8f, 0.8f), 
					  SbColor(0.8f, 0.8f, 0.4f), SbColor(0.8f, 0.0f, 0.f), 
					  SbColor(0.8f, 0.4f, 0.4f), SbColor(0.8f, 0.4f, 0.4f)} ;
  static float    sliceToTranslateRadius[NP_TRANSLATE] = {0.2f, 0.2f, 0.2f} ;
  static short    sliceToTranslateNumber[NP_TRANSLATE] = {0, 1, 2, } ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoSeparator *root = new  SoSeparator ;

  PoIrregularMesh1D *mesh1D = new PoIrregularMesh1D ;
  mesh1D->setGeometry(NP, sliceValues) ;
  mesh1D->addStringsSet(0, sliceNames) ;

  SoAnnoText3Property *annoProp = new SoAnnoText3Property ;
  annoProp->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER ;
  annoProp->fontSizeHint = SoAnnoText3Property::ANNOTATION ;
  
  PoLabelHints *labelHints = new PoLabelHints ;
  labelHints->isLabelLineVisible = TRUE ;

  SoMaterial *mat = new SoMaterial ;
  mat->diffuseColor.setValues(0, NP, sliceDiffColors) ;
  mat->specularColor.setValues(0, NP, sliceSpecColors) ;
  mat->emissiveColor.setValue(0.f, 0.f, 0.f) ;
  mat->shininess.setValue(0.8f) ;
  mat->transparency.setValue(0.f) ;

  PoBevelEdge *bevelEdge = new PoBevelEdge ;
  bevelEdge->radius = 0.2f ;

  PoPieChartRep *pieChart = new PoPieChartRep ;
  pieChart->set("annotationLineApp.drawStyle", "linePattern 0xF0F0") ;
  pieChart->colorBinding = PoChart::PER_PART ;
  pieChart->sliceToTranslateNumber.setValues(0, NP_TRANSLATE, sliceToTranslateNumber) ;
  pieChart->sliceToTranslateRadius.setValues(0, NP_TRANSLATE, sliceToTranslateRadius) ;
  pieChart->material.setValue(mat) ;
  pieChart->isAnnoSliceColor = FALSE ;
  pieChart->isNameVisible = TRUE ;
  pieChart->annoDistToCenter = 0.9F ;
  pieChart->radiusMin = 0.4f ;  

  SoRotationXYZ *rotXYZ = new SoRotationXYZ ;
  rotXYZ->axis = SoRotationXYZ::X ;
  rotXYZ->angle = -1 ;

  root->ref() ;
  root->addChild(rotXYZ) ;
  root->addChild(annoProp) ;
  root->addChild(labelHints) ;
  root->addChild(myTextAttr) ;
  root->addChild(bevelEdge) ;
  root->addChild(mesh1D) ;
  root->addChild(pieChart) ;
  
  SoXtPlaneViewer *viewer = new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  //viewer->setSize(SbVec2s(500,500));
  viewer->setTitle("Pie Chart");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


