//
// PoPointsFieldBars
//
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoLinearAxis.h>
#include <MeshViz/graph/PoGroup6Axis3.h>
#include <MeshViz/graph/PoPointsFieldBars.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoLinearDataMapping.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   static SbVec3f point[9]={SbVec3f(10.,10.,12.), SbVec3f(20.,60.,60.), SbVec3f(60.,20.,90.),
			    SbVec3f(50.,40.,50.), SbVec3f(80.,70.,30.), SbVec3f(80.,30.,20.),
			    SbVec3f(30.,50.,40.), SbVec3f(30.,20.,60.), SbVec3f(30.,80.,30.)};

   static float   barValues[9] = {12.,60.,90.,50.,30.,20.,40.,60.,30.};

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;

   PoDomain    *myDomain = new PoDomain ;
   myDomain->min.setValue( 0.,  0.,  0.) ;
   myDomain->max.setValue(90., 90., 90.) ;
   
   PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
   myTextAttr->fontName = "Courier";

   PoLinearDataMapping *myDataMapping = new PoLinearDataMapping ;
   myDataMapping->value1 = 0. ;
   myDataMapping->value2 = 100. ;
   myDataMapping->color1.setValue(1.0, 1.0, 1.0) ;
   myDataMapping->color2.setValue(1.0, 0.0, 0.0) ;

   PoGroup6Axis3 *g6Axis  = new 
     PoGroup6Axis3(SbVec3f(0.,0.,0.), SbVec3f(90., 90., 90.), PoGroup6Axis3::LINEAR,
		   PoGroup6Axis3::LINEAR, PoGroup6Axis3::LINEAR, "X", "Y", "Z") ;

   PoPointsFieldBars *bars = new PoPointsFieldBars(9, point, barValues, 6.0, 6.0) ;

   root->ref() ;
   root->addChild(myDomain) ;
   root->addChild(myTextAttr) ;
   root->addChild(myDataMapping) ;
   root->addChild(g6Axis) ;
   root->addChild(bars) ;

   SoXtExaminerViewer *viewer = 
     new SoXtExaminerViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Points Field Bars");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


