//
// PoPolarLinAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoSphere.h>

#include <MeshViz/graph/PoPolarLinAxis.h>
#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#include <DialogViz/SoDialogVizAll.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>
#include <GraphEditors.h>
#include <GraphAuditors.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();

  SoSeparator *root = new SoSeparator ;
  
  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(-5., -5.,0) ;
  myDomain->max.setValue(5., 5.,0) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  
  PoPolarLinAxis *polLinAxis = new PoPolarLinAxis(-5,  5.0, 10.0, 0.75) ;
  polLinAxis->titleVisibility = PoAxis::VISIBILITY_ON ;
  polLinAxis->titlePosition = PoAxis::TITLE_END ;
  polLinAxis->titleString.setValue("X-Axis") ;
  polLinAxis->gridVisibility = PoAxis::VISIBILITY_ON ;
  polLinAxis->gridLengthGradSide = 2.3F ;
  polLinAxis->gridLengthGradOtherSide = 1.5 ;

  // Create axis editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createPolarLinAxisEditor();

  PolarLinearGraphAuditor* myAuditor = new PolarLinearGraphAuditor(polLinAxis);

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();

  root->ref() ;

  SoSeparator *sphereSep = new SoSeparator;
  SoMaterial *sphereColor = new SoMaterial;
  sphereColor->diffuseColor = SbColor(1,0,0);
  SoSphere *sphere = new SoSphere;
  sphere->radius = 0.1f;
  sphereSep->addChild(sphereColor);
  sphereSep->addChild(sphere);

  root->addChild(sphereSep);
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(polLinAxis) ;
  
  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Polar Linear Axis");

  viewer->show();
  viewer->viewAll();
  editor->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  editor = NULL;
  delete myAuditor;

  root->unref();
  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


