//
// PoPolarLogAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoPolarLogAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

/*----------------------------------------------------------------------------*/

#include <GraphEditors.h>
#include <GraphAuditors.h>

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
 
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;

  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();
  
  SoSeparator *root = new SoSeparator ;

  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(-2., -2.,0) ;
  myDomain->max.setValue( 2.,  2.,0) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";

  PoPolarLogAxis *polLogAxis = new PoPolarLogAxis(0.0,  0.0, 2.0, 0.75) ;
  polLogAxis->titleVisibility = PoAxis::VISIBILITY_ON ;
  polLogAxis->titlePosition = PoAxis::TITLE_END ;
  polLogAxis->titleString.setValue("X-Axis") ;
  polLogAxis->gridVisibility = PoAxis::VISIBILITY_ON ;
  polLogAxis->gridLengthGradSide = 2.3F ;
  polLogAxis->gridLengthGradOtherSide = 1.5 ;

  // Create axis editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createPolarLogAxisEditor();

  PolarLogGraphAuditor* myAuditor = new PolarLogGraphAuditor(polLogAxis);

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(polLogAxis) ;
  
  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Polar log Axis");

  viewer->show();
  viewer->viewAll();
  editor->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  editor = NULL;
  delete myAuditor;

  root->unref();
  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


