//
// PoProfileBar
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>

#include <MeshViz/graph/PoProfileBar.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoRegularMesh1D.h>
#include <MeshViz/nodes/PoMesh1DHints.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoEllipticProfile.h>

#define NP            10

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  float y[NP] = {0.5F, 3.8F, 1.2F, 7.2F, 9.3F, 7.2F, 6.0F, 7.5F, 4.1F, 1.5F}  ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoDomain *myDomain = new PoDomain ;  
  myDomain->min.setValue(0., 0., 0) ;
  myDomain->max.setValue(10., 10., 10) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoSeparator *root = new SoSeparator ;

  PoRegularMesh1D *mesh1D = new PoRegularMesh1D ;
  mesh1D->setGeometry(NP, 0.5, 9.5) ;
  mesh1D->addValuesSet(0, y) ;

  PoProfileBar *profileBar = new PoProfileBar ;

  PoEllipticProfile *ellipticProfile = new PoEllipticProfile ;
  ellipticProfile->xRadius = 0.4F ;
  ellipticProfile->yRadius = 0.2F ;
  
  PoGroup2Axis *g2Axis = new 
    PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup2Axis::LINEAR, 
		 PoGroup2Axis::LINEAR, "X-Axis", "Y-Axis") ;

  SoMaterial *material = new SoMaterial ;
  material->diffuseColor.setValue(0.7F,  0.F, 0.F) ;
  material->specularColor.setValue(0.8F, 0.F, 0.F) ;
  material->shininess = 0.4F ;

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(ellipticProfile) ;
  root->addChild(mesh1D) ;  
  root->addChild(myTextAttr) ;
  root->addChild(g2Axis) ;
  root->addChild(material) ;
  root->addChild(profileBar) ;

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Profile Bar");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


