//
// PoRectangle
//
////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/engines/SoCompose.h>

#include <MeshViz/graph/PoRectangle.h>

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
   // Initialize Inventor and Xt
   Widget myWindow = SoXt::init(argv[0]) ;
   if (myWindow == NULL) exit(1) ;

   // Initialize the new nodes class
   PoMeshViz::init() ;

   SoSeparator *root = new SoSeparator ;
   PoRectangle *rect = new PoRectangle ;
   PoRectangle *rect2 = new PoRectangle(SbVec2f(-2.,-2.), SbVec2f(-1.5,-1.)) ;
   rect->q.setValue(2.0, 1.0) ;

   SoElapsedTime *counter = new SoElapsedTime;
   SoComposeVec2f *compVec2f = new SoComposeVec2f ;
   counter->speed.setValue(0.1F) ;
   compVec2f->x.connectFrom(&counter->timeOut) ;
   compVec2f->y.connectFrom(&counter->timeOut) ;
   rect->q.connectFrom(&compVec2f->vector);

   root->ref() ;
   root->addChild(rect) ;
   root->addChild(rect2) ;

   SoXtPlaneViewer *viewer = 
     new SoXtPlaneViewer(myWindow);
   viewer->setSceneGraph(root);
   viewer->setTitle("Rectangle");
   viewer->show();
   viewer->viewAll();

   SoXt::show(myWindow);
   SoXt::mainLoop();

  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


