//
// PoSingleHistogram
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoTransformSeparator.h>

#include <MeshViz/graph/PoSingleHistogram.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoLinearDataMapping.h>

#define NUM_VAL 8

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  static const char *names[NUM_VAL] = {
    "JAN","FEB","MAR","APR","MAY","JUNE","JULY","AUG"
  };
  static float value[NUM_VAL] = {
    5., 10., 8., 12., 6., 7., 4., 3.
  }; 

  // Initialize the new nodes class
  PoMeshViz::init() ;

  SoAnnotation *root = new SoAnnotation ;

  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(0., 0.,0) ;
  myDomain->max.setValue(10., 10.,1) ;
 
  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  myTextAttr->endLineChar = '%' ;
  myTextAttr->lineLength = 5 ;

  PoLinearDataMapping *myDataMapping = new PoLinearDataMapping ;
  myDataMapping->value1 = 3. ;
  myDataMapping->value2 = 12. ;
  myDataMapping->color1.setValue(1, 1, 1) ;
  myDataMapping->color2.setValue(0, 1, 0) ;

  PoSingleHistogram *histog = new 
    PoSingleHistogram(SbVec2f(-3., 1.), 13., PoSingleHistogram::X, 
		      NUM_VAL, (const float*)value, (const char**)names) ;

  histog->set("barApp.material", "diffuseColor 0. 1. 0.") ;
  histog->set("valueTextApp.material", "diffuseColor 1 1 1") ;
  histog->set("nameTextApp.material", "diffuseColor 1 1 1") ;
  histog->coloring = PoSingleHistogram::DATA_MAPPING ;
  histog->valueFontSize = 0.06F ;
  histog->nameFontSize = 0.06F ;

  PoSingleHistogram *histog2 = 
    new PoSingleHistogram(SbVec2f(-3., 1.), 13., PoSingleHistogram::X, 
			  NUM_VAL, (const float*)value, NULL) ;
  histog2->set("barApp.material", "diffuseColor 0. 0.5 0.") ;
  histog2->nameVisibility = PoSingleHistogram::VISIBILITY_OFF ;
  histog2->valueVisibility = PoSingleHistogram::VISIBILITY_OFF ;
  
  PoLinearAxis *yAxis = new PoLinearAxis(SbVec3f(-3,1,0), 13, PoLinearAxis::YX) ; 
  yAxis->gradFontSize = 0.06F ;
  yAxis->titleString.setValue("Price%(M Dollars)") ;
  yAxis->titleVisibility = PoLinearAxis::VISIBILITY_ON ;
  yAxis->titleFontSize = 0.06F ;
  yAxis->set("appearance.material", "diffuseColor 1 1 1") ;
  yAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;
  yAxis->set("bodyApp.drawStyle", "lineWidth 2.0") ;

  SoTranslation *translate = new SoTranslation ;
  translate->translation.setValue(0.2F, 0.3F, 0.0F) ;
  
  SoTransformSeparator *transSep = new SoTransformSeparator ;
  transSep->addChild(translate) ;
  transSep->addChild(histog2) ;
  
  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(myDataMapping) ;
  root->addChild(yAxis) ;
  root->addChild(transSep) ;
  root->addChild(histog) ;

  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Single Histogram");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


