//
// PoTimeAxis
////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoTimeAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>
#include <MeshViz/nodes/PoDateFormatMapping.h>

#define DATE1 "09/10/94 16:44:30"
#define DATE2 "09/12/94 16:44:31"

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

#include <GraphEditors.h>
#include <GraphAuditors.h>

int  main(int, char **argv)
{
  static const char *gradRep[] = {
    " 1SEC  s'\"'   : 1MIN  H'h'm' ' D'/'3M'/'4Y",
    "30SEC  s'\" 'm'''' : 1HOU 'h ' D'/'3M'/'4Y",
    " 1MIN  m''''   : 1HOU  H'h ' D'/'3M'/'4Y",
    "30MIN  H'h'm''''   : 1DAY  D'/'3M'/'4Y",
    " 1HOU  H'h'    : 1DAY  D'/'3M'/'4Y",
    "12HOU  D H'h'  : 1MON  3M'/'4Y",
    "DAY  D       : 1MON  3M'/'4Y",
    "15DAY  D'/'3M  : 6MON  4Y",
    " 1MON  3M      : 1YEA  4Y",
    " 1YEA  4Y"
  };
  static const char timesPeriod[] = 
    "30SEC 15MIN 1HOU 12HOU 1DAY 15DAY 1MON 6MON 1YEA";

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  SoDialogViz::init();
  
  SoSeparator *root = new SoSeparator ;

  PoDomain    *myDomain = new PoDomain ;
  myDomain->min.setValue(0., 0., 0.) ;
  myDomain->max.setValue(1., 1., 1.) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier";
  myTextAttr->endLineChar = ':' ;

  PoDateFormatMapping *myDateMapping = new PoDateFormatMapping ;
  myDateMapping->date1 = DATE1 ;
  myDateMapping->date2 = DATE2 ;
  myDateMapping->format = "dmyh'\"" ;
  
  PoTimeAxis *timeAxis = new PoTimeAxis(DATE1, DATE2, 0.) ;
  timeAxis->titleVisibility = PoTimeAxis::VISIBILITY_ON ;
  timeAxis->gradRep.setValues(0, 10, (const char**)gradRep) ;
  timeAxis->timesPeriod.setValue(timesPeriod) ;
  timeAxis->titleString.setValue("Time Axis") ;
  timeAxis->set("bodyApp.material", "diffuseColor 1 0 0") ;

  // Create axis editor
  SoRef<SoTopLevelDialog> editor = GraphEditors::createTimeAxisEditor();

  TimeGraphAuditor* myAuditor = new TimeGraphAuditor( timeAxis );

  editor->addAuditor(myAuditor);
  editor->setSynchronizable(false);
  editor->buildDialog( myWindow, FALSE );
  editor->show();

  root->ref() ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(myDateMapping) ;
  root->addChild(timeAxis) ;
  
  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Time Axis");

  viewer->show();
  viewer->viewAll();
  editor->show();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete viewer;
  editor = NULL;
  delete myAuditor;
  root->unref();

  SoDialogViz::finish();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/
