//
// PoTube
//
////////////////////////////////////////

#if defined(_WIN32)
#pragma warning(disable: 4996) // Disable PoXt deprecation warning
#endif

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCoordinate3.h>

#include <MeshViz/graph/PoTube.h>
#include <MeshViz/graph/PoGroup2Axis.h>
#include <MeshViz/graph/PoLinearAxis.h>

#include <MeshViz/nodes/PoDomain.h>
#include <MeshViz/nodes/PoEllipticProfile.h>
#include <MeshViz/nodes/PoSquareProfile.h>
#include <MeshViz/nodes/PoIrregularMesh1D.h>
#include <MeshViz/nodes/PoMesh1DHints.h>
#include <MeshViz/nodes/PoMiscTextAttr.h>

#define NP            14

/*----------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  float x[NP] = {0.5F, 1.5F, 1.8F, 2.4F, 3.2F, 4.5F, 6.3F, 6.9F, 8.0F, 8.5F, 9.0F,
                 9.5F, 9.8F, 10.F} ;
  float y[NP] = {9.0F, 7.0F, 6.5F, 6.0F, 5.0F, 5.5F, 6.0F, 7.7F, 6.8F, 6.0F, 5.5F, 
		 4.5F, 3.5F, 2.5F}  ;
  float size[NP] = {1, 3, 5, 1, 3, 5, 1, 3, 5, 1, 3, 5, 1, 3} ;

  SbColor colorListD[3] = {SbColor(1,0,0), SbColor(0, 1, 0), SbColor(0, 0, 1)} ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;

  PoDomain *myDomain = new PoDomain ;  
  myDomain->min.setValue(0., 0., -1) ;
  myDomain->max.setValue(10., 10., 1) ;

  PoMiscTextAttr *myTextAttr = new PoMiscTextAttr ;
  myTextAttr->fontName = "Courier" ;

  SoSeparator *root = new SoSeparator ;

  PoIrregularMesh1D *mesh1D = new PoIrregularMesh1D ;
  mesh1D->setGeometry(NP, x) ;
  mesh1D->addValuesSet(0, y) ;
  mesh1D->addValuesSet(1, size) ;

  PoMesh1DHints *mesh1DHints = new PoMesh1DHints ;
  mesh1DHints->geomInterpretation = PoMesh1DHints::SMOOTH ;

  SoMaterial *mat = new SoMaterial ;
  mat->diffuseColor.setValues(0, 3, colorListD) ;

  PoEllipticProfile *profile = new PoEllipticProfile ;
  profile->xRadius = 0.15F ;
  profile->yRadius = 0.025F ;

  PoTube *tube = new PoTube ;
  tube->material.setValue(mat) ;
  tube->colorBinding = PoTube::PER_VERTEX ;
  tube->thicknessFactor = 0.5 ;
  tube->thicknessIndex = 1 ;

  PoGroup2Axis *g2Axis = new
    PoGroup2Axis(SbVec2f(0.,0.), SbVec2f(10., 10.), PoGroup2Axis::LINEAR,
		 PoGroup2Axis::LINEAR, "X-Axis", "Y-Axis") ;
  PoLinearAxis *zAxis = new PoLinearAxis(SbVec3f(0,0,-1), 1, PoLinearAxis::ZY) ;  

  root->ref() ;
  root->addChild(mesh1D) ;
  root->addChild(myDomain) ;
  root->addChild(myTextAttr) ;
  root->addChild(mesh1DHints) ;
  root->addChild(profile) ;
  root->addChild(tube) ;
  root->addChild(zAxis) ;
  root->addChild(g2Axis) ;

  SoXtExaminerViewer *viewer = new SoXtExaminerViewer(myWindow);
  viewer->setSceneGraph(root);
  //viewer->setSize(SbVec2s(500,500));
  viewer->setTitle("Tube");
  viewer->show();
  viewer->viewAll();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


