//
// PoValuedMarkerField
//
////////////////////////////////////////

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtPlaneViewer.h>
#include <Inventor/nodes/SoSeparator.h>

#include <MeshViz/graph/PoValuedMarkerField.h>

#include <MeshViz/nodes/PoLinearDataMapping.h>

#define NP 10

/*---------------------------------------------------------------------------*/

#include <Inventor/SoWinApp.h>

int  main(int, char **argv)
{
  static float   sizes[NP] = {100, 300, 500, 600, 900, 800, 700, 300, 400, 200} ;
  static float   values[NP] = {1.2665F, 3.45F, 7.5F, 8.99F, 12.F, 11.55F, 9.3F, 3.31416F, 5.5F, 2.F} ;
  static SbVec2f points[NP] = {SbVec2f(1.F,1.F), SbVec2f(2.,2.), SbVec2f(3.,3.), 
			       SbVec2f(4.,4.), SbVec2f(5.,5.), SbVec2f(6.,6.),
			       SbVec2f(7.,7.), SbVec2f(8.,8.), SbVec2f(9.,9.), 
			       SbVec2f(9.5,10.)} ;

  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  // Initialize the new nodes class
  PoMeshViz::init() ;
  
  PoLinearDataMapping *myDataMapping = new PoLinearDataMapping ;
  myDataMapping->value1 = 1. ;
  myDataMapping->value2 = 12. ;
  myDataMapping->color1.setValue(1, 0, 0) ;
  myDataMapping->color2.setValue(0, 0, 1) ;

  SoSeparator *root = new SoSeparator ;
  PoValuedMarkerField *valMkFld = new PoValuedMarkerField(NP, points, values, sizes) ;

  root->ref() ;
  root->addChild(myDataMapping) ;
  root->addChild(valMkFld) ;

  SoXtPlaneViewer *viewer = 
    new SoXtPlaneViewer(myWindow);
  viewer->setSceneGraph(root);
  viewer->setTitle("Valued Marker Field");
  viewer->show();
  viewer->viewAll();
  
  SoXt::show(myWindow);
  SoXt::mainLoop();
  
  delete viewer;
  root->unref();
  PoMeshViz::finish();
  SoXt::finish();

  return 0;
}/*---------------------------------------------------------------------------*/


